% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleIW.R
\name{sampleIW}
\alias{sampleIW}
\title{Fast sampler for the inverse-Wishart distribution}
\usage{
sampleIW(nu, Psi_inv)
}
\arguments{
\item{nu}{Numeric. Degrees of freedom \eqn{\nu} of the inverse-Wishart
(must exceed \eqn{p - 1}).}

\item{Psi_inv}{Numeric \eqn{p \times p} SPD matrix equal to
\eqn{\Psi^{-1}}, the inverse of the inverse-Wishart scale matrix.}
}
\value{
A \eqn{p \times p} SPD matrix \eqn{S} distributed as
  \eqn{\mathcal{IW}_p(\nu, \Psi)}.
}
\description{
Draw a random sample from an inverse-Wishart distribution
\eqn{\mathcal{IW}_p(\nu, \Psi)} using the identity
\eqn{S \sim \mathcal{IW}_p(\nu, \Psi)} iff
\eqn{S^{-1} \sim W_p(\nu, \Psi^{-1})}. This implementation accepts
\eqn{\Psi^{-1}} directly for speed.
}
\details{
Sampling scheme:
\itemize{
  \item Sample \eqn{W \sim W_p(\nu, \Psi^{-1})} using \code{rWishart}.
  \item Return \eqn{S = W^{-1}}, which has
        \eqn{\mathcal{IW}_p(\nu, \Psi)}.
}

Parameterization:
\itemize{
  \item \eqn{\nu} is the degrees of freedom, must satisfy
        \eqn{\nu > p - 1}.
  \item \eqn{\Psi} is the SPD scale matrix of the inverse-Wishart.
        This function expects its inverse \eqn{\Psi^{-1}} as input
        for efficiency (avoids repeated matrix inversions).
}

Note that:
(i) internally calls \code{rWishart(1, df = nu, Sigma = Psi_inv)}, and
(ii) returns \code{solve(W)}; if numerical issues arise, consider
        adding a small ridge to \eqn{\Psi^{-1}} prior to sampling.
}
\examples{

set.seed(123)
p <- 3
# Construct an SPD scale matrix Psi
A <- matrix(rnorm(p * p), p, p)
Psi <- crossprod(A) + diag(p) * 0.5
Psi_inv <- solve(Psi)

# Draw one inverse-Wishart sample
S <- sampleIW(nu = p + 5, Psi_inv = Psi_inv)
S

}
