% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPC3d.R
\name{OPC3d}
\alias{OPC3d}
\title{Plot results of OPC analysis of a surface (3D HTML widget; numbered legend; distinct colors)}
\usage{
OPC3d(
  OPC_File,
  binColors = NULL,
  patchOutline = FALSE,
  outlineColor = "black",
  maskDiscard = FALSE,
  legend = TRUE,
  main = "",
  cex = 1,
  scaleLegend = FALSE,
  legendTextCol = "black",
  legendLineCol = "black",
  leftOffset = 0,
  fieldofview = 0,
  widget_size_px = 768,
  scene_zoom = 1.5,
  title_font_size_px = 30,
  title_font_family =
    "system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif",
  legend_magnify = 1,
  fileName = NA,
  binary = FALSE
)
}
\arguments{
\item{OPC_File}{An object that stores the output of \code{OPC()}}

\item{binColors}{Optional character vector of colors for each directional bin. If not supplied,
a high-contrast set is generated automatically (Okabe–Ito <= 12 bins; vivid HCL rainbow for more).}

\item{patchOutline}{Logical; draw patch boundary outlines on the mesh (default \code{FALSE})}

\item{outlineColor}{Color for patch outlines (default \code{"black"})}

\item{maskDiscard}{Logical; color discarded/small patches black in the mesh (default \code{FALSE})}

\item{legend}{Logical; show a right-hand legend (default \code{TRUE})}

\item{main}{Character; plot title (default \code{""})}

\item{cex}{Numeric; relative size multiplier for legend text (default \code{1})}

\item{scaleLegend}{Logical; scale legend pie wedges by patch counts (default \code{FALSE})}

\item{legendTextCol}{Color for legend text (default \code{"black"})}

\item{legendLineCol}{Color for legend ring/lines (default \code{"black"})}

\item{leftOffset}{Numeric (-1..1); small horizontal camera nudge (default \code{0})}

\item{fieldofview}{Numeric; field of view in degrees; 0 = isometric (default \code{0})}

\item{widget_size_px}{Integer; square size of the 3D widget in pixels (default \code{768})}

\item{scene_zoom}{Numeric; initial zoom on the 3D scene (default \code{1.5})}

\item{title_font_size_px}{Integer; title font size in pixels (default \code{30})}

\item{title_font_family}{CSS font-family for title/legend (default system UI stack)}

\item{legend_magnify}{Numeric; additional legend scale factor (default \code{1})}

\item{fileName}{Character or \code{NA}; if non-\code{NA}, write a colored *.ply to disk (default \code{NA})}

\item{binary}{Logical; write PLY as binary (default \code{FALSE}, i.e., ascii)}
}
\value{
\itemize{
\item \strong{Interactive}: an \code{htmltools}-browsable object (title, 3D widget, legend).
\item \strong{Non-interactive}: (invisibly) a list with class \code{"OPC3d_spec"} containing:
\code{title}, \code{bin_colors}, \code{face_colors}, \code{bin_sizes}, \code{bin_labels}, \code{legend}, \code{scaled}.
}
}
\description{
Produces a three-dimensional rendering of face orientation on a surface and
returns an HTML widget with a clean, numbered pie legend
Wedges can be scaled by patch counts. Default colors emphasize clarity.
}
\details{
Run \code{OPC()} first to compute patches and directional bins.

\strong{Legend}
Wedges are \strong{numbered (1..N)} and can be \strong{scaled} to patch counts.

\strong{Saving a PLY}
When \code{fileName} is provided, a colorized PLY is written. Colors are assigned per face via a
vertex-duplication strategy so external tools (e.g., MeshLab) show the same appearance. For ascii
PLY, a comment line notes the generator/version.
}
\examples{
# OPC_out <- OPC(Tooth)
if (interactive()) {
  OPC3d(OPC_out, legend = TRUE, scaleLegend = TRUE,
        main = "OPC -- Numbered Bins")
}

}
