% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swap.R
\name{swap}
\alias{swap}
\title{Swap polynomial indeterminates}
\usage{
swap(p, variable, replacement)
}
\arguments{
\item{p}{polynomial}

\item{variable}{the variable in the polynomial to replace}

\item{replacement}{the replacement variable}
}
\value{
a mpoly object
}
\description{
Swap polynomial indeterminates
}
\examples{

(p <- mp("(x + y)^2"))
swap(p, "x", "t")

## the meta data is retained
(p <- bernstein(3, 5))
(p2 <- swap(p, "x", "t"))
is.bernstein(p2)

(p <- chebyshev(3))
(p2 <- swap(p, "x", "t"))
is.chebyshev(p2)


}
\author{
David Kahle
}
