% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_parallel.R
\name{parallel_mrgsim_ei}
\alias{parallel_mrgsim_ei}
\alias{future_mrgsim_ei}
\alias{fu_mrgsim_ei}
\alias{fu_mrgsim_ei0}
\alias{mc_mrgsim_ei}
\title{Simulate an idata set in parallel}
\usage{
future_mrgsim_ei(
  mod,
  events,
  idata,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = TRUE,
  .parallel = TRUE
)

fu_mrgsim_ei(
  mod,
  events,
  idata,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = TRUE,
  .parallel = TRUE
)

fu_mrgsim_ei0(..., .dry = TRUE)

mc_mrgsim_ei(
  mod,
  events,
  idata,
  nchunk = 4,
  ...,
  .as_list = FALSE,
  .p = NULL,
  .dry = FALSE,
  .seed = NULL,
  .parallel = TRUE
)
}
\arguments{
\item{mod}{The mrgsolve model object see \link[mrgsolve:mrgmod-class]{mrgsolve::mrgmod}.}

\item{events}{An event object from mrgsolve; see \code{\link[mrgsolve:ev]{mrgsolve::ev()}}.}

\item{idata}{An idata set of parameters, one per simulation unit (individual);
see \code{\link[mrgsolve:idata_set]{mrgsolve::idata_set()}}.}

\item{nchunk}{Number of chunks in which to split the data set; chunking will
be based on the \code{ID} column, which is required in \code{data}.}

\item{...}{Passed to \code{\link[mrgsolve:mrgsim_variants]{mrgsolve::mrgsim_d()}}.}

\item{.as_list}{If \code{TRUE} a list is return; otherwise (default) a data frame}

\item{.p}{Post processing function executed on the worker; arguments should
be (1) the simulated output (2) the model object.}

\item{.dry}{If \code{TRUE} neither the simulation nor the post processing will
be done.}

\item{.seed}{Passed to \code{\link[future.apply:future_lapply]{future.apply::future_lapply()}} as \code{future.seed}.}

\item{.parallel}{if \code{FALSE}, the simulation will not be parallelized; this is
intended for debugging and testing use only.}
}
\value{
A data frame or list of simulated data.
}
\description{
Use \link{future_mrgsim_ei} to simulate with the \code{future} package.  Use
\link{mc_mrgsim_ei} to simulate with \code{parallel::mclapply}.
}
\examples{

mod <- mrgsolve::house()

events <- mrgsolve::ev(amt = 100)

idata <- data.frame(CL = runif(10, 0.5, 1.5))

out <- future_mrgsim_ei(mod, events, idata)

}
\seealso{
\link{future_mrgsim_ei}
}
