% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.mtrank.R
\name{fitted.mtrank}
\alias{fitted.mtrank}
\alias{print.fitted.mtrank}
\title{Calculate pairwise fitted probabilities for \code{\link{mtrank}} object.}
\usage{
\method{fitted}{mtrank}(object, treat1, treat2, type, ...)

\method{print}{fitted.mtrank}(x, type = attr(x, "type"), digits = 4, ...)
}
\arguments{
\item{object}{An object of class \code{\link{mtrank}}.}

\item{treat1}{The first treatment considered in the treatment comparison.}

\item{treat2}{The second treatment considered in the treatment comparison.}

\item{type}{A character vector specifying the probability of interest.
Either "better", "tie", "worse", or "all" (can be abbreviated).}

\item{\dots}{Additional arguments (passed on to \code{\link{prmatrix}}).}

\item{x}{An object of class \code{\link{fitted.mtrank}}.}

\item{digits}{Minimal number of significant digits for proportions,
see \code{print.default}.}
}
\value{
The probability (or probabilities) of interest for the comparison
\code{treat1} vs \code{treat2} based on the argument \code{type}.
}
\description{
This function uses the estimates of ability and tie prevalence parameters
from a \code{\link{mtrank}} object and calculates fitted pairwise
probabilities about the preference or the tie between two treatments based on
equations (7) and (8) in Evrenoglou et al. (2024).
}
\details{
Pairwise fitted probabilities between any two treatments in the network can
be calculated using the ability estimates obtained from \code{\link{mtrank}}
and equations (7) and (8) in Evrenoglou et al. (2024). The fitted
probabilities are calculated in the direction \code{treat1} vs \code{treat2}.
The available probability types are
\itemize{
\item "better": probability that \code{treat1} is better than \code{treat2},
\item "tie": probability that \code{treat1} is equal to \code{treat2},
\item "worse": probability that \code{treat1} is worse than \code{treat2},
\item "all": all three probabilities.
}

Please note that all the arguments of this function are mandatory.
}
\examples{
data(antidepressants)
#
pw1 <- pairwise(studlab = studyid, treat = drug_name,
  n = ntotal, event = responders,
  data = antidepressants, sm = "OR")
# Use subset to reduce runtime
pw0 <- subset(pw1, studyid < 60)
#
net0 <- netmeta(pw0, reference.group = "tra")
#
ranks0 <- tcc(net0, swd = 1.20, small.values = "undesirable")
#
fit0 <- mtrank(ranks0)
#
fitted(fit0, type = c("better", "worse"),
  treat1 = "bupropion", treat2 = "escitalopram")
#
fitted(fit0, type = c("better", "worse"),
  treat1 = "escitalopram", treat2 = "bupropion")
#
fitted(fit0, type = "all",
  treat1 = c("bupropion", "escitalopram"),
  treat2 = c("escitalopram", "bupropion"))

\dontrun{
# Run analysis with full data set
net1 <- netmeta(pw1, reference.group = "tra")
#
ranks1 <- tcc(net1, swd = 1.20, small.values = "undesirable")
#
fit1 <- mtrank(ranks1)
#
fitted(fit1, type = c("better", "worse"),
  treat1 = "bupropion", treat2 = "escitalopram")
#
fitted(fit1, type = c("better", "worse"),
  treat1 = "escitalopram", treat2 = "bupropion")
#
fitted(fit1, type = "all",
  treat1 = c("bupropion", "escitalopram"),
  treat2 = c("escitalopram", "bupropion"))
}

}
\references{
Evrenoglou T, Nikolakopoulou A, Schwarzer G, Rücker G, Chaimani A (2024):
Producing treatment hierarchies in network meta-analysis using probabilistic
models and treatment-choice criteria,
\url{https://arxiv.org/abs/2406.10612}
}
