% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start.em.R
\name{start_em}
\alias{start_em}
\title{Starting values for parameters}
\arguments{
\item{data}{A data set object; we denote the dimension of a data set to be \eqn{m}.}

\item{v}{Covariate(s); we denote the dimension of it to be \eqn{r}.}

\item{K}{Number of mixture components, the default is \code{K = 2}.}

\item{steps}{Number of iterations. This will only be used when using \code{option = 2} for both the 1-level model and the 2-level model.
It should also be used when using \code{option = 3} and \code{option = 4} for the 1-level model, provided \code{var_fun} is set to either 3 or 4;
the default is \code{steps = 20}.}

\item{option}{Four options for selecting the starting values for the parameters. The default is \code{option = 1}.
When \code{option = 1}: \eqn{\pi_k} = \eqn{\frac{1}{K}}, \eqn{z_k} ~ rnorm(\eqn{K}, mean = 0, sd=1), \eqn{\alpha} = column means, \eqn{\beta} = a random row minus alpha,
\eqn{\Gamma} = coefficient estimates from separate linear models, \eqn{\Sigma} is diagonal matrix where the diagonals take the value of column standard deviations over \eqn{K};
when \code{option = 2}: use a short run (\code{steps = 5}) of the EM function which uses \code{option = 1} with \code{var_fun = 1} and use the estimates as the starting values for all the parameters;
when \code{option = 3}: the starting value of \eqn{\beta} is the first principal component, and the starting values for the rest of the parameters are the same as described when \code{option = 1};
when \code{option = 4}: first, take the scores of the first principal component of the data and perform \eqn{K}-means, \eqn{\pi_k} is the proportion of the clustering assignments, and \eqn{z_k} take the values of the \eqn{K}-means centers,
and the starting values for the rest of the parameters are the same as described when \code{option = 1}.}

\item{var_fun}{The four variance specifications. When \code{var_fun = 1}, the same diagonal variance specification to all \eqn{K} components of the mixture;
\code{var_fun = 2}, different diagonal variance matrices for different components.
\code{var_fun = 3}, the same full (unrestricted) variance for all components.
\code{var_fun = 4}, different full (unrestricted) variance matrices for different components.
If unspecified, \code{var_fun = 2}. Note that for application propose, in two-level models, \code{var_fun} can only take values of 1 or 2.}

\item{p}{optional; specifies starting values for \eqn{\pi_k}, it is input as a \eqn{K}-dimensional vector.}

\item{z}{optional; specifies starting values for \eqn{z_k}, it is input as a \eqn{K}-dimensional vector.}

\item{beta}{optional; specifies starting values for \eqn{\beta}, it is input as an \eqn{m}-dimensional vector.}

\item{alpha}{optional; specifies starting values for \eqn{\alpha}, it is input as an \eqn{m}-dimensional vector.}

\item{sigma}{optional; specifies starting values for \eqn{\Sigma_k} (\eqn{\Sigma}, when \code{var_fun = 1} or \code{var_fun = 3}), when \code{var_fun = 1}, it is input as an \eqn{m}-dimensional vector,
when \code{var_fun = 2}, it is input as a list (of length \eqn{K}) of \eqn{m}-dimensional vectors, when \code{var_fun = 3}, it is input as an \eqn{m \times m} matrix,
when \code{var_fun = 4}, it is input as a list (of length \eqn{K}) of \eqn{m \times m} matrices.}

\item{gamma}{optional; the coefficients for the covariates; specifies starting values for \eqn{\Gamma}, it is input as an \eqn{m \times r} matrix.}
}
\value{
The starting values (in a list) for parameters in the models \eqn{x_{i} = \alpha + \beta z_k + \Gamma v_i + \varepsilon_i} (Zhang and Einbeck, 2024) and
        \eqn{x_{ij} = \alpha + \beta z_k + \Gamma v_{ij} + \varepsilon_{ij}} (Zhang et al., 2023) used in the four fucntions: \link{mult.em_1level}, \link{mult.em_2level}, \link{mult.reg_1level} and \link{mult.reg_2level}.
 \item{p}{The starting value for the parameter \eqn{\pi_k}, which is a vector of length \eqn{K}.}
 \item{alpha}{The starting value for the parameter \eqn{\alpha}, which is a vector of length \eqn{m}.}
 \item{z}{The starting value for the parameter \eqn{z_k}, which is a vector of length \eqn{K}.}
 \item{beta}{The starting value for the parameter \eqn{\beta}, which is a vector of length \eqn{m}.}
 \item{gamma}{The starting value for the parameter \eqn{\Gamma}, which is a matrix.}
 \item{sigma}{The starting value for the parameter \eqn{\Sigma_k}.
                     When \code{var_fun = 1}, \eqn{\Sigma_k} is a diagonal matrix and \eqn{\Sigma_k = \Sigma}, and we obtain a vector of the diagonal elements;
                     When \code{var_fun = 2}, \eqn{\Sigma_k} is a diagonal matrix, and we obtain \code{K} vectors of the diagonal elements;
                     When \code{var_fun = 3}, \eqn{\Sigma_k} is a full variance-covariance matrix, \eqn{\Sigma_k = \Sigma}, and we obtain a matrix \eqn{\Sigma};
                     When \code{var_fun = 4}, \eqn{\Sigma_k} is a full variance-covariance matrix, and we obtain \code{K} different matrices \eqn{\Sigma_k}.}
}
\description{
The starting values for parameters used for the EM algorithm in the functions: \link{mult.em_1level}, \link{mult.em_2level}, \link{mult.reg_1level} and \link{mult.reg_2level}.
}
\examples{
##example for the faithful data.
data(faithful)
start <- start_em(faithful, option = 1)
}
\references{
Zhang, Y., Einbeck, J. and Drikvandi, R. (2023). A multilevel multivariate response model for data with latent structures.
In: Proceedings of the 37th International Workshop on Statistical Modelling, pages 343-348.
Link on RG: \url{https://www.researchgate.net/publication/375641972_A_multilevel_multivariate_response_model_for_data_with_latent_structures}.

Zhang, Y. and Einbeck, J. (2024). A Versatile Model for Clustered and Highly Correlated Multivariate Data. J Stat Theory Pract 18(5).\doi{10.1007/s42519-023-00357-0}
}
