% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_center_raster.R
\name{scale_center_raster}
\alias{scale_center_raster}
\title{Scale and Center Raster Layers Using Model Parameters}
\usage{
scale_center_raster(r, multiScaleR, clamp = FALSE, pct_mx = 0)
}
\arguments{
\item{r}{A `terra::SpatRaster` containing covariate layers to be scaled. All layer names must match those used in the `multiScaleR` model.}

\item{multiScaleR}{A `multiScaleR` object created using `kernel_prep` or `multiScale_optim`.}

\item{clamp}{Logical. If `TRUE`, scaled values are clamped to the covariate range in the model data.}

\item{pct_mx}{Numeric. If `clamp` is `TRUE`, this value specifies the amount (percentage; positive or negative) by which to expand/contract the min/max range when clamping. Default = 0.}
}
\value{
A `terra::SpatRaster` with each layer scaled and optionally clamped.
}
\description{
Standardizes raster covariates in a `terra::SpatRaster` using mean and standard deviation values extracted from a fitted model `multiScaleR` model.
}
\keyword{internal}
