% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimize_VL.R
\name{vl_dist}
\alias{vl_dist}
\title{How far apart are two scales?}
\usage{
vl_dist(
  set_1,
  set_2,
  method = c("taxicab", "euclidean", "chebyshev", "hamming"),
  rounder = 10
)
}
\arguments{
\item{set_1, set_2}{Numeric vectors of pitch-classes in the sets. Must be
of same length.}

\item{method}{What distance metric should be used? Defaults to \code{"taxicab"}
but can be \code{"euclidean"}, \code{"chebyshev"}, or \code{"hamming"}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric: distance between \code{set_1} and \code{set_2}
}
\description{
Using the chosen \code{method} to measure distance, determines how far
apart two scales are in voice-leading space.
}
\examples{
c_major <- c(0, 4, 7)
a_minor_63 <- c(0, 4, 9)
f_minor_64 <- c(0, 5, 8)
vl_dist(c_major, a_minor_63)
vl_dist(c_major, f_minor_64)
vl_dist(c_major, a_minor_63, method="euclidean")
vl_dist(c_major, f_minor_64, method="euclidean")

}
