% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVS.R
\name{importance.MVS}
\alias{importance.MVS}
\title{Calculate feature importance from an "MVS" object.}
\usage{
\method{importance}{MVS}(x, ...)
}
\arguments{
\item{x}{An object of class "MVS".}

\item{...}{Further arguments to be passed to \code{\link[randomForest]{importance}}.}
}
\value{
An object of S3 class "MVSimportance".
}
\description{
Calculate feature importance at each level from an "MVS" object based on random forests.
}
\examples{
\donttest{ 
set.seed(012)
n <- 1000
X <- matrix(rnorm(8500), nrow=n, ncol=85)
views <- c(rep(1,45), rep(2,20), rep(3,20))
beta <- c(rep(10, 55), rep(0, 30)) * ((rbinom(85, 1, 0.5)*2)-1)
eta <- X \%*\% beta
p <- 1 /(1 + exp(-eta))
y <- rbinom(n, 1, p)

## 2-level MVS with random forest
fit <- MVS(x=X, y=y, views=views, type = "RF")
importance(fit)}
}
\author{
Wouter van Loon <w.s.van.loon@fsw.leidenuniv.nl>
}
\keyword{TBA}
