% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nltt_values.R
\name{get_nltt_values}
\alias{get_nltt_values}
\title{Get the nLTT values in time}
\usage{
get_nltt_values(phylogenies, dt)
}
\arguments{
\item{phylogenies}{the phylogenies, supplied as either
a list or a multiPhylo object, where the phylogenies are of type 'phylo'}

\item{dt}{The timestep resolution,
where 1/dt is the number of points evaluated}
}
\value{
A dataframe of timepoints with the nLTT value
  of each phylogeny in time
}
\description{
Collect the nLTT values in time
over all phylogenies in the long form.
}
\examples{

  # Create some random phylogenies
  phylogeny1 <- ape::rcoal(10)
  phylogeny2 <- ape::rcoal(20)
  phylogeny3 <- ape::rcoal(30)
  phylogeny4 <- ape::rcoal(40)
  phylogeny5 <- ape::rcoal(50)
  phylogeny6 <- ape::rcoal(60)
  phylogeny7 <- ape::rcoal(70)
  phylogenies <- c(phylogeny1, phylogeny2, phylogeny3,
    phylogeny4, phylogeny5, phylogeny6, phylogeny7
  )

  # Obtain the nLTT values
  dt <- 0.2
  nltt_values <- get_nltt_values(phylogenies, dt = dt)

}
\seealso{
Use\link{nltts_diff} to compare nLTT statistic between one focal
tree and a set of one or more other trees
}
\author{
Richèl Bilderbeek
}
