% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-math.R
\name{dual-maxmin}
\alias{dual-maxmin}
\alias{max,dualr-method}
\alias{min,dualr-method}
\title{Piecewise max and min for dual numbers}
\usage{
\S4method{max}{dualr}(x, ..., na.rm = FALSE)

\S4method{min}{dualr}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{A dual number.}

\item{...}{Additional dual or numeric values.}

\item{na.rm}{Ignored.}
}
\value{
A \code{dual} representing the max or min.
}
\description{
Compares on value and propagates the derivative of the selected branch.
}
\examples{
x <- dual_variable(3)
y <- dual_variable(5)
value(max(x, y))
value(min(x, y))

}
