% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_weights.R
\name{determine_super_learner_weights_nnls}
\alias{determine_super_learner_weights_nnls}
\title{Determine SuperLearner Weights with Nonnegative Least Squares}
\usage{
determine_super_learner_weights_nnls(data, y_variable, obs_weights = NULL)
}
\arguments{
\item{data}{A data frame consisting of an outcome (y_variable) and
other columns corresponding to predictions from candidate learners.}

\item{y_variable}{The string name of the outcome column in \code{data}.}

\item{obs_weights}{A vector of weights for each observation that dictate
how prediction should be more targeted to higher weighted observations.}
}
\value{
A vector of weights to be used for each of the learners.
}
\description{
This function accepts a dataframe that is structured to have
one column \code{Y} and other columns with unique names corresponding to
different model predictions for \code{Y}, and it will use nonnegative
least squares to determine the weights to use for a SuperLearner.
}
\examples{
# suppose that we have a data.frame of predictions from different candidate
# learners:
prediction_data <- data.frame(
  lm = lnr_lm(mtcars, mpg ~ hp)(mtcars),
  rf = lnr_rf(mtcars, mpg ~ hp)(mtcars),
  rf2 = lnr_rf(mtcars, mpg ~ hp, ntree = 20)(mtcars),
  earth = lnr_earth(mtcars, mpg ~ hp)(mtcars))
# make sure it includes the outcome y_variable
prediction_data$mpg <- mtcars$mpg

# we can use determine_super_learner_weights() fn to apply the non-negative least
# squares algorithm to produce weights for averaging the learners
determine_super_learner_weights_nnls(
  data = prediction_data,
  y_variable = 'mpg')

}
