% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abcfgwc.R
\name{abcfgwc}
\alias{abcfgwc}
\title{Fuzzy Geographicaly Weighted Clustering with Artificial Bee Colony Optimization}
\usage{
abcfgwc(
  data,
  pop = NA,
  distmat = NA,
  ncluster = 2,
  m = 2,
  distance = "euclidean",
  order = 2,
  alpha = 0.7,
  a = 1,
  b = 1,
  error = 1e-05,
  max.iter = 100,
  randomN = 0,
  vi.dist = "uniform",
  nfood = 10,
  n.onlooker = 5,
  limit = 4,
  pso = F,
  abc.same = 10
)
}
\arguments{
\item{data}{an object of data with d>1. Can be \code{matrix} or \code{data.frame}. If your data is univariate, bind it with \code{1} to get a 2 columns.}

\item{pop}{an n*1 vector contains population.}

\item{distmat}{an n*n distance matrix between regions.}

\item{ncluster}{an integer. The number of clusters.}

\item{m}{degree of fuzziness or fuzzifier. Default is 2.}

\item{distance}{the distance metric between data and centroid, the default is euclidean, see \code{\link[rdist]{cdist}} for details.}

\item{order, }{minkowski order. default is 2.}

\item{alpha}{the old membership effect with [0,1], if \code{alpha} equals 1, it will be same as fuzzy C-Means, if 0, it equals to neighborhood effect.}

\item{a}{spatial magnitude of distance. Default is 1.}

\item{b}{spatial magnitude of population. Default is 1.}

\item{error}{error tolerance. Default is 1e-5.}

\item{max.iter}{maximum iteration. Default is 500.}

\item{randomN}{random seed for initialisation (if uij or vi is NA). Default is 0.}

\item{vi.dist}{a string of centroid population distribution between \code{"uniform"} (default) and \code{"normal"}. Can be defined as \code{vi.dist=} in \code{opt_param}.}

\item{nfood}{number of foods population. Can be defined as \code{npar=} in \code{opt_param}.}

\item{n.onlooker}{number of onlooker bees, Can be defined as \code{n.onlooker} in \code{opt_param}.}

\item{limit}{number of turns to eliminate food with no solutions. Can be defined as \code{limit} in \code{opt_param}.}

\item{pso}{whether to add PSO term in bee's movement. Either \code{TRUE} or \code{FALSE}. Can be defined as \code{pso} in \code{opt_param}.}

\item{abc.same}{number of consecutive unchange to stop the iteration. Can be defined as \code{same=} in \code{opt_param}.}
}
\value{
an object of class \code{"fgwc"}.\cr
An \code{"fgwc"} object contains as follows:
\itemize{
\item \code{converg} - the process convergence of objective function
\item \code{f_obj} - objective function value
\item \code{membership} - membership matrix
\item \code{centroid} - centroid matrix
\item \code{validation} - validation indices (there are partition coefficient (\code{PC}), classification entropy (\code{CE}), 
SC index (\code{SC}), separation index (\code{SI}), Xie and Beni's index (\code{XB}), IFV index (\code{IFV}), and Kwon index (Kwon))
\item \code{max.iter} - Maximum iteration
\item \code{cluster} - the cluster of the data
\item \code{finaldata} - The final data (with the cluster)
\item \code{call} - the syntax called previously
\item \code{time} - computational time.
}
}
\description{
Fuzzy clustering with addition of spatial configuration of membership matrix with centroid optimization using Artificial Bee Colony
}
\details{
Fuzzy Geographically Weighted Clustering (FGWC) was developed by \insertCite{fgwc;textual}{naspaclust} by adding 
neighborhood effects and population to configure the membership matrix in Fuzzy C-Means. Furthermore,
the Artificial Bee Colony (ABC) algorithm was developed by \insertCite{Karaboga2007;textual}{naspaclust} in order to get a more optimal
solution of a certain complex function. FGWC using ABC has been implemented previously by \insertCite{fgwcabc1;textual}{naspaclust} and \insertCite{fgwcabc2;textual}{naspaclust}.
}
\examples{
data('census2010')
data('census2010dist')
data('census2010pop')
# First way
res1 <- abcfgwc(census2010,census2010pop,census2010dist,3,2,'euclidean',4,nfood=10)
# Second way
# initiate parameter
param_fgwc <- c(kind='v',ncluster=3,m=2,distance='minkowski',order=3,
               alpha=0.5,a=1.2,b=1.2,max.iter=1000,error=1e-6,randomN=10)
## tune the ABC parameter
abc_param <- c(vi.dist='normal',npar=5,pso=FALSE,same=15,n.onlooker=5,limit=5) 
##FGWC with ABC optimization algorithm
res2 <- fgwc(census2010,census2010pop,census2010dist,'abc',param_fgwc,abc_param) 
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fpafgwc}} \code{\link{gsafgwc}}
}
