% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantVPC.R
\name{quantVPC}
\alias{quantVPC}
\title{The quantified visual predictive check plot (QVPC)}
\usage{
quantVPC(orig_data,
         sim_data,
         N_xbin = NULL,
         prob = 0.5,
         X_name = "TIME",
         Y_name = "DV",
         MissingDV = NULL,
         Kmethod = "cluster",                
         maxK = NULL,
         beta = 0.2,
         lambda = 0.3,
         R = 4,
         C1 = 2.5,
         C2 = 7.8, ...)
}
\arguments{
\item{orig_data}{A data frame of original data with X and Y variable.}

\item{sim_data}{A matrix of simulated data with only Y values collected.}

\item{N_xbin}{Number of bins in X variable. If NULL, optimal number of bins are automatically calcuated using optK function.}

\item{prob}{Scalar of probability.}

\item{X_name}{Name of X variable in orig_data (usually "TIME" in pharmacokinetic data).}

\item{Y_name}{Name of Y variable in orig_data (usually "DV" in pharmacokinetic data).}

\item{MissingDV}{Name of missing indicator variable in orig_data, which have value 1 if missing, value 0 otherwise. (usually "MDV" in pharmacokinetic data).}

\item{Kmethod}{The way to calculate the penalty in automatic binning."cluster" or "kernel".}

\item{maxK}{The maximum number of bins.}

\item{beta}{Additional parameter for automatic binning, used in optK function.}

\item{lambda}{Additional parameter for automatic binning, used in optK function.}

\item{R}{Additional parameter for automatic binning, used in optK function.}

\item{C1}{Additional parameter for automatic binning, used in optK function.}

\item{C2}{Additional parameter for automatic binning, used in optK function.}

\item{...}{Arguments to be passed to methods.}
}
\value{
quantVPC plot
}
\description{
The quantified visual predictive check visually represents 
actual and unavailable observations around predicted medians, regardless 
of the density or shape of the observed data distribution, through the 
form of a percent.
}
\examples{
data(origdata)
data(simdata)
#quantVPC(origdata,simdata,prob=0.5,N_xbin=8)
}
\references{
Post, T.M., et al. (2008)
Extensions to the visual predictive check for facilitate model performance
evaluation, Journal of pharmacokinetics and pharmacodynamics,
35(2), 185-202
}
