% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.operator.R
\name{step_elimination}
\alias{step_elimination}
\title{Screen elimination type (linear vs Michaelis-Menten)}
\usage{
step_elimination(
  dat,
  start.mod = NULL,
  search.space = "ivbase",
  no.cores = NULL,
  param_table = NULL,
  penalty.control = NULL,
  precomputed_results_file = NULL,
  filename = "test",
  foldername = NULL,
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{start.mod}{A named integer vector specifying the starting model
code. If NULL, a base model is generated using \code{base_model()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{penalty.control}{A list of penalty control parameters defined by
\code{penaltyControl()}, specifying penalty values used for model diagnostics
during fitness evaluation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{foldername}{Character string specifying the name of the folder to be
created in the current working directory to store intermediate results.
If NULL, a name is generated automatically.}

\item{.modEnv}{Optional internal environment used to store model indices
and cached results across model-selection steps.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments passed to \code{mod.run()}.}
}
\value{
A list with the following elements:
\itemize{
\item results_table: a data.frame with one row per candidate
model, including model description, Fitness, AIC, BIC, and OFV.
\item best_code: named integer vector corresponding to the best
candidate's model code.
\item best_row: one-row data.frame summarizing the best
candidate.
}
}
\description{
Runs linear and Michaelis-Menten elimination candidates by modifying only the
elimination setting in the current model code.
}
\details{
When mm = 0, any inter-individual variability term for Km
(eta.km) present in the model code is automatically set to zero.
}
\examples{
\donttest{
  dat <- pheno_sd
  param_table <- initialize_param_table()
  param_table$init[param_table$Name == "lcl"] <- log(0.008)
  param_table$init[param_table$Name == "lvc"] <- log(0.6)
  penalty.control = penaltyControl()
  penalty.control$penalty.terms = c("rse", "theta", "covariance")
  # Initialize start.mod with a base model
   start.mod <- base_model("ivbase")
  step_elimination(
    dat = dat,
    start.mod = start.mod,
    search.space = "ivbase",
    param_table = param_table,
    filename = "step_elim_test",
    penalty.control = penalty.control,
    saem.control = nlmixr2est::saemControl(logLik = TRUE,nBurn=15,nEm=15)
  )
}

}
\seealso{
\code{\link{mod.run}}, \code{\link{base_model}}, \code{\link{penaltyControl}}
}
\author{
Zhonghui Huang
}
