% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McSweeny_Porter.r
\name{McSweeny_Porter}
\alias{McSweeny_Porter}
\title{McSweeny and Porter Method for Nonparametric ANCOVA}
\usage{
McSweeny_Porter(data, formula)
}
\arguments{
\item{data}{A data frame containing the variables specified in the formula.}

\item{formula}{An object of class "formula": a symbolic description of the 
model to be fitted. The structure should be `response ~ covariate1 + ... + group`.}
}
\value{
A list containing the following components:
\describe{
  \item{regression_equation_covariate}{Summary of the model with only covariates.}
  \item{regression_equation_covariate_group}{Summary of the model with covariates and group main effects.}
  \item{group_effect}{The result of an ANOVA test for group effect.}
  \item{interaction_effect}{The result of an ANOVA test for interaction effect between group and covariate variables.}
  \item{regression_equation_interaction}{Summary of the model including the interaction term.}
  \item{data}{The original data frame with added columns for ranks.}
}
}
\description{
Performs rank-based ANCOVA with and without an interaction term between the covariates and the group.
}
\examples{
# 1. Create a sample data frame
data <- data.frame(
  group = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3),
  response = c(16, 60, 82, 126, 137, 44, 67, 87, 100, 142, 17, 28, 105, 149, 160),
  covariate1 = c(26, 10, 42, 49, 55, 21, 28, 5, 12, 58, 1, 19, 41, 48, 35),
  covariate2 = c(12, 21, 24, 29, 34, 17, 2, 40, 38, 36, 8, 1, 9, 28, 16)
)

# 2. Run the McSweeny and Porter method
results <- McSweeny_Porter(
  formula = response ~ covariate1 + covariate2 + group,
  data = data
)

# 3. View the results
print(results)
print(results$group_effect)
print(results$interaction_effect)

}
\references{
McSweeney M, Porter AJOp. Small sample properties of nonparametric index of response and rank analysis of covariance. 1971;16.

Olejnik SF, Algina JJER. A review of nonparametric alternatives to analysis of covariance. 1985;9(1):51-83.
}
