% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteLexicon.R
\name{deleteLexicon}
\alias{deleteLexicon}
\title{Delete a previously loaded lexicon}
\usage{
deleteLexicon(labbcat.url, lexicon)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance.}

\item{lexicon}{The name of the lexicon to delete, e.g. 'cmudict'}
}
\value{
NULL if the deletion was successful, or an error message if not.
}
\description{
By default LaBB-CAT includes a layer manager called the Flat Lexicon Tagger, which can
be configured to annotate words with data from a dictionary loaded from a plain text
file (e.g. a CSV file).
}
\details{
This function deletes such a lexicon, which was previously added using loadLexicon.

You must have editing privileges in LaBB-CAT in order to be able to use this function.
}
\examples{
\dontrun{
## Delete the previously loaded CMU Pronouncing Dictionary lexicon
deleteLexicon(labbcat.url, "cmudict")
}

}
\seealso{
Other dictionary functions: 
\code{\link{addDictionaryEntry}()},
\code{\link{addLayerDictionaryEntry}()},
\code{\link{getDictionaries}()},
\code{\link{getDictionaryEntries}()},
\code{\link{loadLexicon}()},
\code{\link{removeDictionaryEntry}()},
\code{\link{removeLayerDictionaryEntry}()}
}
\concept{dictionary functions}
