% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneplot.R
\name{oneplot}
\alias{oneplot}
\title{Plot Observed Data and Model Predictions}
\usage{
oneplot(
  model1,
  model2 = NULL,
  model3 = NULL,
  model4 = NULL,
  df,
  maxpred = NULL,
  ylimit = NULL,
  ccex = 1.5
)
}
\arguments{
\item{model1}{The first fitted model object, either a one-inflated model (class `"oneinflmodel"`) 
or a truncated model (class `"truncmodel"`).}

\item{model2}{Optional. A second fitted model object, structured similarly to \code{model1}.}

\item{model3}{Optional. A third fitted model object.}

\item{model4}{Optional. A fourth fitted model object.}

\item{df}{A data frame containing the variables used in the models.}

\item{maxpred}{Optional. The maximum count value to include in the plot. Defaults to the maximum observed count.}

\item{ylimit}{Optional. The upper limit for the y-axis. Defaults to 1.1 times the highest observed frequency.}

\item{ccex}{Optional. A numeric value controlling the size of plot points and lines. Defaults to \code{1.5}.}
}
\value{
A plot is generated but no values are returned.
}
\description{
Generates a bar plot of observed count data and overlays predicted values 
from one or more models fitted using \code{\link{oneinfl}} or \code{\link{truncreg}}.
}
\details{
This function visualizes observed count data as a bar plot and overlays predicted 
values from up to four models. The function automatically detects the type of model 
(Poisson or negative binomial; one-inflated or truncated) and adjusts the plot accordingly. 
Predictions are generated using the \code{\link{pred}} function.

Model types are distinguished by different point and line styles:
\itemize{
  \item Poisson (PP): Dark magenta, triangle-down
  \item Zero-truncated negative binomial (ZTNB): Red, diamond
  \item One-inflated Poisson (OIPP): Green, triangle-up
  \item One-inflated zero-truncated negative binomial (OIZTNB): Blue, circle
}

The legend in the top-right corner of the plot indicates the models displayed.
}
\examples{
# Example usage
df <- data.frame(x = rnorm(100), z = rnorm(100), y = rpois(100, lambda = 5) + 1)
model1 <- oneinfl(y ~ x | z, df = df, dist = "Poisson")
model2 <- truncreg(y ~ x, df = df, dist = "Poisson")
oneplot(model1, model2, df = df, maxpred = 10)

}
\seealso{
\code{\link{oneinfl}} for fitting one-inflated models.
\code{\link{truncreg}} for fitting truncated models.
\code{\link{pred}} for generating predictions used in the plot.
}
