% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openair-package.R
\docType{package}
\name{openair-package}
\alias{openair}
\alias{openair-package}
\title{openair: Tools for the Analysis of Air Pollution Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Tools to analyse, interpret and understand air pollution data. Data are typically regular time series and air quality measurement, meteorological data and dispersion model output can be analysed. The package is described in Carslaw and Ropkins (2012, \doi{10.1016/j.envsoft.2011.09.008}) and subsequent papers.
}
\details{
This is a UK Natural Environment Research Council (NERC) funded
knowledge exchange project that aims to make available innovative analysis
tools for air pollution data; with additional support from Defra. The tools
have generally been developed to analyse data of hourly resolution (or at
least a regular time series) both for air pollution monitoring and
dispersion modelling. The availability of meteorological data at the same
time resolution greatly enhances the capabilities of these tools.

\code{openair} contains collection of functions to analyse air pollution data.
Typically it is expected that data are hourly means, although most
functions consider other time periods. The principal aim to make available
analysis techniques that most users of air quality data and model output
would not normally have access to. The functions consist of those developed
by the authors and a growing number from other researchers.

The package also provides access to a wide range of data sources including
the UK Automatic Urban and Rural Network (AURN), networks run by Imperial
College London (e.g., the LAQN) and the Scottish Air Quality Network
(SAQN).

The package has a number of requirements for input data and these are
discussed in the manual (available in the \code{openair} book at
\url{https://openair-project.github.io/openair/}). The key requirements are
that a date or date-time field must have the name \code{date} (and can be \code{Date}
or \code{POSIXct} format), that wind speed is represented as \code{ws} and that wind
direction is \code{wd}.

Most functions work in a very straightforward way, but offer many options
for finer control and perhaps more in-depth analysis.

NOTE: openair assumes that data are not expressed in local time where
'Daylight Saving Time' is used. All functions check that this is the case
and issue a warning if TRUE. It is recommended that data are expressed in
UTC/GMT (or a fixed offset from) to avoid potential problems with R and
\code{openair} functions. The \code{openair} book provides advice on these issues
(available on the website).

To check to see if \code{openair} has been correctly installed, try some of the
examples below.
}
\section{The \code{openair} class}{


As well as generating the plots themselves, \code{openair} plotting functions
also return an object of class \code{"openair"}. The object includes three main
components:
\itemize{
\item \code{call}, the command used to generate the plot.
\item \code{data}, the data frame of summarised information used to make the
plot.
\item \code{plot}, the plot itself.
}

If retained, e.g., using \code{output <- polarPlot(mydata, "nox")}, this output
can be used to recover the data, reproduce or rework the original plot or
undertake further analysis.

An \code{openair} output can be manipulated using a number of generic
operations, including \code{print}, \code{plot} and \code{summary}. The examples below
show some examples of using an \code{openair} object.
}

\examples{
\dontrun{
# load package
library(openair)

# summarise data in a compact way
summaryPlot(mydata)

# traditional wind rose
windRose(mydata)

# polar plot
polar_nox <- polarPlot(mydata, pollutant = "nox")

# see call
polar_nox$call

# get data
polar_nox$data

# could, e.g., re-plot in {ggplot2}
library(ggplot2)
ggplot(polar_nox$data, aes(u, v, fill = z)) +
  geom_tile() +
  coord_equal() +
  scale_fill_gradientn(colours = openair::openColours(), na.value = NA)
}

}
\references{
Most reference details are given under the specific functions.
The principal reference is below.
\itemize{
\item Carslaw, D.C. and K. Ropkins, (2012) openair --- an R package for
air quality data analysis.  Environmental Modelling & Software.
Volume 27-28, 52-61.
}
}
\seealso{
See \url{https://openair-project.github.io/openair/} for up to date
information on the project, and the openair book
(\url{https://openair-project.github.io/book/}) for thorough documentation and
examples.
}
\author{
\strong{Maintainer}: David Carslaw \email{david.carslaw@york.ac.uk} (\href{https://orcid.org/0000-0003-0991-950X}{ORCID})

Authors:
\itemize{
  \item Jack Davison \email{jack.davison@ricardo.com} (\href{https://orcid.org/0000-0003-2653-6615}{ORCID})
  \item Karl Ropkins \email{K.Ropkins@its.leeds.ac.uk} (\href{https://orcid.org/0000-0002-0294-6997}{ORCID})
}

}
\keyword{internal}
