% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassWorkset.R
\name{load_workset}
\alias{load_workset}
\alias{load_scenario}
\alias{OpenMppWorkset}
\title{OpenM++ Workset Class}
\usage{
load_workset(model, set)

load_scenario(model, set)
}
\arguments{
\item{model}{Model digest or model name.}

\item{set}{Name of workset (input set of model parameters).}
}
\value{
An \code{OpenMppWorkset} instance.
}
\description{
OpenM++ Workset Class
}
\details{
\code{load_scenario()} is an alias for \code{load_workset()}.
}
\examples{
\dontrun{
use_OpenMpp_local()
load_workset("RiskPaths", "Default")
load_scenario("RiskPaths", "Default")
}


}
\section{Super class}{
\code{\link[openmpp:OpenMppModel]{openmpp::OpenMppModel}} -> \code{OpenMppWorkset}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{WorksetName}}{Workset name.}

\item{\code{WorksetMetadata}}{Workset metadata.}

\item{\code{OpenMppType}}{OpenM++ object type (used for \code{print()}).}

\item{\code{Parameters}}{Workset parameters.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ReadOnly}}{Workset read-only status.}

\item{\code{BaseRunDigest}}{Base run digest for input parameters.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenMppWorkset-new}{\code{OpenMppWorkset$new()}}
\item \href{#method-OpenMppWorkset-print}{\code{OpenMppWorkset$print()}}
\item \href{#method-OpenMppWorkset-set_base_digest}{\code{OpenMppWorkset$set_base_digest()}}
\item \href{#method-OpenMppWorkset-delete_base_digest}{\code{OpenMppWorkset$delete_base_digest()}}
\item \href{#method-OpenMppWorkset-copy_params}{\code{OpenMppWorkset$copy_params()}}
\item \href{#method-OpenMppWorkset-delete_params}{\code{OpenMppWorkset$delete_params()}}
\item \href{#method-OpenMppWorkset-get_param}{\code{OpenMppWorkset$get_param()}}
\item \href{#method-OpenMppWorkset-set_param}{\code{OpenMppWorkset$set_param()}}
\item \href{#method-OpenMppWorkset-run}{\code{OpenMppWorkset$run()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-new}{}}}
\subsection{Method \code{new()}}{
Create a new OpenMppWorkset object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$new(model, set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{Model digest or name.}

\item{\code{set}}{Workset name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{OpenMppWorkset} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-print"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{OpenMppWorkset} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not currently used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-set_base_digest"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-set_base_digest}{}}}
\subsection{Method \code{set_base_digest()}}{
Set the base run digest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$set_base_digest(base)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base}}{Base run digest.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-delete_base_digest"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-delete_base_digest}{}}}
\subsection{Method \code{delete_base_digest()}}{
Delete the base run digest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$delete_base_digest()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-copy_params"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-copy_params}{}}}
\subsection{Method \code{copy_params()}}{
Copy parameters from a base scenario.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$copy_params(names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{Character vector of parameter names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-delete_params"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-delete_params}{}}}
\subsection{Method \code{delete_params()}}{
Delete parameters from scenario.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$delete_params(names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{Character vector of parameter names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-get_param"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-get_param}{}}}
\subsection{Method \code{get_param()}}{
Retrieve a parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$get_param(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Parameter name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{tibble}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-set_param"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-set_param}{}}}
\subsection{Method \code{set_param()}}{
Set a parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$set_param(name, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Parameter name.}

\item{\code{data}}{New parameter data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppWorkset-run"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppWorkset-run}{}}}
\subsection{Method \code{run()}}{
Initiate a model run for the model workset/scenario.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppWorkset$run(
  name,
  opts = opts_run(),
  wait = FALSE,
  wait_time = 0.2,
  progress = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Run name.}

\item{\code{opts}}{Run options. See \code{\link[=opts_run]{opts_run()}} for more details.}

\item{\code{wait}}{Logical. Should we wait until the model run is done?}

\item{\code{wait_time}}{Number of seconds to wait between status checks.}

\item{\code{progress}}{Logical. Should a progress bar be shown?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
}
