% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modified_newton.R
\name{modified_newton}
\alias{modified_newton}
\title{Modified Newton-Raphson Optimization}
\usage{
modified_newton(
  start,
  objective,
  gradient = NULL,
  hessian = NULL,
  lower = -Inf,
  upper = Inf,
  control = list(),
  ...
)
}
\arguments{
\item{start}{Numeric vector. Starting values for the optimization parameters.}

\item{objective}{Function. The objective function to minimize.}

\item{gradient}{Function (optional). Gradient of the objective function.}

\item{hessian}{Function (optional). Hessian matrix of the objective function.}

\item{lower}{Numeric vector. Lower bounds for box constraints.}

\item{upper}{Numeric vector. Upper bounds for box constraints.}

\item{control}{List. Control parameters including convergence flags:
\itemize{
  \item \code{use_abs_f}: Logical. Use absolute change in objective for convergence.
  \item \code{use_rel_f}: Logical. Use relative change in objective for convergence.
  \item \code{use_abs_x}: Logical. Use absolute change in parameters for convergence.
  \item \code{use_rel_x}: Logical. Use relative change in parameters for convergence.
  \item \code{use_grad}: Logical. Use gradient norm for convergence.
  \item \code{use_posdef}: Logical. Verify positive definiteness at convergence.
  \item \code{use_pred_f}: Logical. Record predicted objective decrease.
  \item \code{use_pred_f_avg}: Logical. Record average predicted decrease.
  \item \code{grad_diff}: String. Method for gradient differentiation.
  \item \code{hess_diff}: String. Method for Hessian differentiation.
}}

\item{...}{Additional arguments passed to objective, gradient, and Hessian functions.}
}
\value{
A list containing optimization results and iteration metadata.
}
\description{
Implements an optimized Newton-Raphson algorithm for non-linear optimization 
featuring dynamic ridge adjustment and backtracking line search.
}
\details{
\code{modified_newton} is a line search optimization algorithm that utilizes 
second-order curvature information (the Hessian matrix) to find the minimum 
of an objective function.

\bold{Modified Newton vs. Trust-Region:}
Unlike the \code{dogleg} and \code{double_dogleg} functions which use a 
Trust-Region approach to constrain the step size, this function uses a 
\bold{Line Search} approach. It first determines the Newton direction 
(the solution to \eqn{H \Delta x = -g}) and then performs a backtracking line 
search to find a step length \eqn{\alpha} that satisfies the sufficient decrease 
condition (Armijo condition).

\bold{Dynamic Ridge Adjustment:}
If the Hessian matrix \eqn{H} is not positive definite (making it unsuitable for 
Cholesky decomposition), the algorithm applies a dynamic ridge adjustment. 
A diagonal matrix \eqn{\tau I} is added to the Hessian, where \eqn{\tau} is 
increased until the matrix becomes positive definite. This ensures the 
search direction always remains a descent direction.

\bold{Differentiation Methods:}
The function allows for independent selection of differentiation methods for 
the gradient and Hessian:
\itemize{
   \item \code{forward}: Standard forward-difference numerical differentiation.
   \item \code{central}: Central-difference (more accurate but slower).
   \item \code{complex}: Complex-step differentiation (highly accurate for gradients).
   \item \code{richardson}: Richardson extrapolation via the \code{numDeriv} package.
}
}
