% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup.R
\name{orderly_cleanup}
\alias{orderly_cleanup}
\alias{orderly_cleanup_status}
\title{Clean up source directory}
\usage{
orderly_cleanup(name = NULL, dry_run = FALSE, root = NULL)

orderly_cleanup_status(name = NULL, root = NULL)
}
\arguments{
\item{name}{Name of the report directory to clean (i.e., we look
at \verb{src/<name>} relative to your orderly root}

\item{dry_run}{Logical, indicating if we should \emph{not} delete
anything, but instead just print information about what we would
do}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function \strong{does} require that the directory is
configured for orderly, and not just outpack (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
An (currently unstable) object of class
\code{orderly_cleanup_status} within which the element \code{delete}
indicates files that would be deleted (for
\code{orderly_cleanup_status}) or that were deleted (for
\code{orderly_cleanup})
}
\description{
Find, and delete, file that were generated by running a report.
Until you're comfortable with what this will do, you are strongly
recommended to run \code{orderly_cleanup_status} first to see what will
be deleted.
}
\details{
After file deletion, we look through and remove all empty
directories; orderly has similar semantics here to git where
directories are never directly tracked.

For recent \code{gert} we will ask git if files are ignored; if ignored
then they are good candidates for deletion! We encourage you to
keep a per-report \code{.gitignore} that lists files that will copy
into the source directory, and then we can use that same
information to clean up these files after generation.
Importantly, even if a file matches an ignore rule but has been
committed to your repository, it will no longer match the ignore
rule.
}
\section{Notes for user of orderly1}{


In orderly1 this function has quite different semantics, because
the full set of possible files is always knowable from the yaml
file. So there, we start from the point of view of the list of
files then compare that with the directory.
}

\examples{
# Create a simple example:
path <- orderly_example()

# We simulate running a packet interactively by using 'source';
# you might have run this line-by-line, or with the "Source"
# button in Rstudio.
source(file.path(path, "src/data/data.R"), chdir = TRUE)

# Having run this, the output of the report is present in the
# source directory:
fs::dir_tree(path)

# We can detect what might want cleaning up by running
# "orderly_cleanup_status":
orderly_cleanup_status("data", root = path)

# Soon this will print more nicely to the screen, but for now you
# can see that the status of "data.rds" is "derived", which means
# that orderly knows that it is subject to being cleaned up; the
# "delete" element shows what will be deleted.

# Do the actual deletion:
orderly_cleanup("data", root = path)
}
