% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-scaffold.r
\name{coord_scaffold}
\alias{coord_scaffold}
\title{Convenience coordinate system for scaffolding axes}
\usage{
coord_scaffold(
  window_ratio = 1,
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  clip = "on"
)
}
\arguments{
\item{window_ratio}{aspect ratio of plotting window}

\item{xlim, ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}
}
\description{
2- (and 3-) dimensional biplots require that coordinates lie on
the same scale but may additionally benefit from a square plotting window.
While \code{CoordRect} provides control of coordinate and window aspect ratios,
the convenience \code{CoordScaffold} system also fixes the coordinate aspect
ratio at \code{1} and gives the user control only of the plotting window.
}
\examples{
# resize the plot to see that the specified aspect ratio is maintained
p <- ggplot(mtcars, aes(mpg, hp/10)) + geom_point()
p + coord_scaffold()
p + coord_scaffold(window_ratio = 2)

# prevent rescaling in response to `theme()` aspect ratio
p <- ggplot(mtcars, aes(mpg, hp/5)) + geom_point()
p + coord_equal() + theme(aspect.ratio = 1)
p + coord_scaffold() + theme(aspect.ratio = 1)

# NB: `theme(aspect.ratio = )` overrides `Coord*$aspect`:
p + coord_fixed(ratio = 1) + theme(aspect.ratio = 1)
p + coord_scaffold(window_ratio = 2) + theme(aspect.ratio = 1)
}
