% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwasCredibleSetsQuery.R
\name{gwasCredibleSetsQuery}
\alias{gwasCredibleSetsQuery}
\title{Retrieve GWAS Credible Sets data for a specified target and disease.}
\usage{
gwasCredibleSetsQuery(ensemblId, efoId, size = 500)
}
\arguments{
\item{ensemblId}{Character. Ensembl gene ID, e.g., "ENSG00000169174".}

\item{efoId}{Character. EFO disease ID, e.g., "EFO_0004911".}

\item{size}{Integer. Number of rows to fetch. Default: 500.}
}
\value{
A tibble with credible set evidence or NULL if no data found.
}
\description{
This function queries the Open Targets Platform GraphQL API to retrieve GWAS credible sets
evidence data for a specified target gene and disease.
}
\examples{
\dontrun{
  result <- gwasCredibleSetsQuery(
    ensemblId = "ENSG00000169174",
    efoId = "EFO_0004911",
    size = 5
  )
  print(result)
}
}
