% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSWQuery.R
\docType{class}
\name{CSWQuery}
\alias{CSWQuery}
\title{CSWQuery}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an CSW Query
}
\description{
CSWQuery

CSWQuery
}
\examples{
  #CSWQuery - elementSetName
  query_full <- CSWQuery$new()
  query_brief <- CSWQuery$new(elementSetName = "brief")
  query_summary <- CSWQuery$new(elementSetName = "summary")
  
  #CSWQuery - cqlText with title
  cons <- CSWConstraint$new(cqlText = "dc:title like '\%ips\%'")
  query <- CSWQuery$new(constraint = cons)
  
  #CSW 2.0.2 - Query - Filter / AnyText
  filter <- OGCFilter$new( PropertyIsLike$new("csw:AnyText", "\%Physio\%"))
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(constraint = cons)
  
  #CSW 2.0.2 - Query - Filter / AnyText Equal
  filter <- OGCFilter$new( PropertyIsEqualTo$new("csw:AnyText", "species"))
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(constraint = cons)
  
  #CSW 2.0.2 - Query - Filter / AnyText And Not
  filter <- OGCFilter$new(And$new(
    PropertyIsLike$new("csw:AnyText", "\%lorem\%"),
    PropertyIsLike$new("csw:AnyText", "\%ipsum\%"),
    Not$new(
      PropertyIsLike$new("csw:AnyText", "\%dolor\%")
    )
  ))
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(constraint = cons)
 
  #CSW 2.0.2 - Query - Filter / AnyText And nested Or
  filter <- OGCFilter$new(And$new(
    PropertyIsEqualTo$new("dc:title", "Aliquam fermentum purus quis arcu"),
    PropertyIsEqualTo$new("dc:format", "application/pdf"),
    Or$new(
      PropertyIsEqualTo$new("dc:type", "http://purl.org/dc/dcmitype/Dataset"),
      PropertyIsEqualTo$new("dc:type", "http://purl.org/dc/dcmitype/Service"),
      PropertyIsEqualTo$new("dc:type", "http://purl.org/dc/dcmitype/Image"),
      PropertyIsEqualTo$new("dc:type", "http://purl.org/dc/dcmitype/Text")
    )
  ))
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(elementSetName = "brief", constraint = cons)
  
  #CSW 2.0.2 - Query - Filter / BBOX
  bbox <- matrix(c(-180,180,-90,90), nrow = 2, ncol = 2, byrow = TRUE,
                 dimnames = list(c("x", "y"), c("min","max")))
  filter <- OGCFilter$new( BBOX$new(bbox = bbox) )
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(elementSetName = "brief", constraint = cons)
  
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{OGC}
\keyword{Query}
\section{Super class}{
\code{\link[ows4R:OGCAbstractObject]{ows4R::OGCAbstractObject}} -> \code{CSWQuery}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ElementSetName}}{element set name property for request XML encoding}

\item{\code{constraint}}{property for request XML encoding}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CSWQuery-new}{\code{CSWQuery$new()}}
\item \href{#method-CSWQuery-setServiceVersion}{\code{CSWQuery$setServiceVersion()}}
\item \href{#method-CSWQuery-clone}{\code{CSWQuery$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="ERROR"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-ERROR'><code>ows4R::OGCAbstractObject$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="INFO"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-INFO'><code>ows4R::OGCAbstractObject$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="WARN"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-WARN'><code>ows4R::OGCAbstractObject$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="encode"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-encode'><code>ows4R::OGCAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClass"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClass'><code>ows4R::OGCAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClassName"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClassName'><code>ows4R::OGCAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getNamespaceDefinition"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getNamespaceDefinition'><code>ows4R::OGCAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="isFieldInheritedFrom"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-isFieldInheritedFrom'><code>ows4R::OGCAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="logger"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-logger'><code>ows4R::OGCAbstractObject$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="print"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-print'><code>ows4R::OGCAbstractObject$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSWQuery-new"></a>}}
\if{latex}{\out{\hypertarget{method-CSWQuery-new}{}}}
\subsection{Method \code{new()}}{
This method is used to instantiate an CSWQUery object. The \code{elementSetName} can be 
   either "full" (default), "brief" or "summary". A constraint \code{CSWConstraint} can be
   defined for the query. The \code{typeNames} indicates to query (default "csw:Record").
   The \code{serviceVersion} gives the CSW service version (default "2.0.2")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSWQuery$new(
  elementSetName = "full",
  constraint = NULL,
  typeNames = "csw:Record",
  serviceVersion = "2.0.2"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{elementSetName}}{element set name. Default is "full"}

\item{\code{constraint}}{object of class \link{CSWConstraint}}

\item{\code{typeNames}}{type names}

\item{\code{serviceVersion}}{CSW service version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSWQuery-setServiceVersion"></a>}}
\if{latex}{\out{\hypertarget{method-CSWQuery-setServiceVersion}{}}}
\subsection{Method \code{setServiceVersion()}}{
Set service version. The methods ensures propery naming of typeNames depending on the service version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSWQuery$setServiceVersion(serviceVersion)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serviceVersion}}{service version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSWQuery-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CSWQuery-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSWQuery$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
