% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OWSServiceIdentification.R
\docType{class}
\name{OWSServiceIdentification}
\alias{OWSServiceIdentification}
\title{OWSServiceIdentification}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an OGC Service Identification
}
\description{
OWSServiceIdentification

OWSServiceIdentification
}
\note{
Abstract class used internally by \pkg{ows4R}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Identification}
\keyword{OGC}
\keyword{OWS}
\keyword{Service}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OWSServiceIdentification-new}{\code{OWSServiceIdentification$new()}}
\item \href{#method-OWSServiceIdentification-getName}{\code{OWSServiceIdentification$getName()}}
\item \href{#method-OWSServiceIdentification-getTitle}{\code{OWSServiceIdentification$getTitle()}}
\item \href{#method-OWSServiceIdentification-getAbstract}{\code{OWSServiceIdentification$getAbstract()}}
\item \href{#method-OWSServiceIdentification-getKeywords}{\code{OWSServiceIdentification$getKeywords()}}
\item \href{#method-OWSServiceIdentification-getOnlineResource}{\code{OWSServiceIdentification$getOnlineResource()}}
\item \href{#method-OWSServiceIdentification-getServiceType}{\code{OWSServiceIdentification$getServiceType()}}
\item \href{#method-OWSServiceIdentification-getServiceTypeVersion}{\code{OWSServiceIdentification$getServiceTypeVersion()}}
\item \href{#method-OWSServiceIdentification-getFees}{\code{OWSServiceIdentification$getFees()}}
\item \href{#method-OWSServiceIdentification-getAccessConstraints}{\code{OWSServiceIdentification$getAccessConstraints()}}
\item \href{#method-OWSServiceIdentification-clone}{\code{OWSServiceIdentification$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-new"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{OWSServiceIdentification}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$new(xmlObj, owsVersion, serviceVersion)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xmlObj}}{object of class \link[XML]{XMLInternalNode-class} from \pkg{XML}}

\item{\code{owsVersion}}{OWS version}

\item{\code{serviceVersion}}{service version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getName"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getName}{}}}
\subsection{Method \code{getName()}}{
Get service identification - name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the name, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getTitle"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getTitle}{}}}
\subsection{Method \code{getTitle()}}{
Get service identification - title
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getTitle()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the title, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getAbstract"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getAbstract}{}}}
\subsection{Method \code{getAbstract()}}{
Get service identification - abstract
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getAbstract()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the abstract, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getKeywords}{}}}
\subsection{Method \code{getKeywords()}}{
Get service identification - keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getKeywords()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the keywords, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getOnlineResource"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getOnlineResource}{}}}
\subsection{Method \code{getOnlineResource()}}{
Get service identification - online resource
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getOnlineResource()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the online resource, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getServiceType"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getServiceType}{}}}
\subsection{Method \code{getServiceType()}}{
Get service identification - service type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getServiceType()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the service type, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getServiceTypeVersion"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getServiceTypeVersion}{}}}
\subsection{Method \code{getServiceTypeVersion()}}{
Get service identification - service type version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getServiceTypeVersion()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the service type version, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getFees"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getFees}{}}}
\subsection{Method \code{getFees()}}{
Get service identification - fees
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getFees()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the fees, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-getAccessConstraints"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-getAccessConstraints}{}}}
\subsection{Method \code{getAccessConstraints()}}{
Get service identification - access constraints
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$getAccessConstraints()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the access constraints, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OWSServiceIdentification-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OWSServiceIdentification-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OWSServiceIdentification$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
