% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal_palette.R
\name{pal_palette}
\alias{pal_palette}
\alias{is_palette}
\alias{as_palette}
\title{Colour palettes}
\usage{
pal_palette(...)

is_palette(x)

as_palette(x)
}
\arguments{
\item{...}{\itemize{
\item For \code{pal_palette()}: A named list of character vectors of any of the three
kinds of R colour specifications, or a named list of colour vectors of
class \code{\link[=pal_colour]{palettes_colour}}.
}}

\item{x}{\itemize{
\item For \code{as_palette()}: An object to be coerced.
\item For \code{is_palette()}: An object to test.
}}
}
\value{
An S3 list of class \code{palettes_palette}.
}
\description{
This creates a list of colour vectors.
}
\details{
Colours can be specified using either:
\itemize{
\item Hexadecimal strings of the form \code{"#RRGGBB"} or \code{"#RRGGBBAA"}
\item Colour names from \code{\link[grDevices:colors]{grDevices::colors()}}
\item Positive integers \code{i} that index into \code{\link[grDevices:palette]{grDevices::palette()}}\verb{[i]}
}
}
\examples{
pal_palette(
  Egypt = c("#DD5129", "#0F7BA2", "#43B284", "#FAB255"),
  Java  = c("#663171", "#CF3A36", "#EA7428", "#E2998A", "#0C7156")
)

x <- list(
  Egypt = c("#DD5129", "#0F7BA2", "#43B284", "#FAB255"),
  Java  = c("#663171", "#CF3A36", "#EA7428", "#E2998A", "#0C7156")
)
as_palette(x)
}
\seealso{
\code{\link[=pal_colour]{pal_colour()}}
}
