% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_masked.R
\name{masked_config}
\alias{masked_config}
\title{Returns the configuration of a masked model}
\usage{
masked_config(
  model = getOption("pangoling.masked.default"),
  config_model = NULL
)
}
\arguments{
\item{model}{Name of a pre-trained model or folder. One should be able to use
models based on "bert". See
\href{https://huggingface.co/models?other=bert}{hugging face website}.}

\item{config_model}{List with other arguments that control how the
model from Hugging Face is accessed.}
}
\value{
A list with the configuration of the model.
}
\description{
Returns the configuration of a masked model.
}
\details{
A masked language model (also called BERT-like, or encoder model) is a type
of large language model  that can be used to predict the content of a mask
in a sentence.

If not specified, the masked model that will be used is the one set in
specified in the global option \code{pangoling.masked.default}, this can be
accessed via \code{getOption("pangoling.masked.default")} (by default
"bert-base-uncased"). To change the default option
use \code{options(pangoling.masked.default = "newmaskedmodel")}.

A list of possible masked can be found in
\href{https://huggingface.co/models?pipeline_tag=fill-mask}{Hugging Face website}

Using the  \code{config_model} and \code{config_tokenizer} arguments, it's possible to
control how the model and tokenizer from Hugging Face is accessed, see the
python method
\href{https://huggingface.co/docs/transformers/v4.25.1/en/model_doc/auto#transformers.AutoProcessor.from_pretrained}{\code{from_pretrained}}
for details. In case of errors check the status of
\url{https://status.huggingface.co/}
}
\examples{
\dontshow{if (installed_py_pangoling()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
masked_config(model = "bert-base-uncased")
\dontshow{\}) # examplesIf}
}
\seealso{
Other masked model helper functions: 
\code{\link{masked_preload}()}
}
\concept{masked model helper functions}
