% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableRow.R
\name{find_tableRow}
\alias{find_tableRow}
\alias{tableRow}
\alias{tableRow<-}
\title{Functions to work with rows in tables}
\usage{
find_tableRow(table, row, withExtras = FALSE, withData = TRUE)

tableRow(table, row, withExtras = FALSE, withData = TRUE)

tableRow(table, row, asis = FALSE, withExtras = FALSE, withData = TRUE) <- value
}
\arguments{
\item{table}{A tabular-like environment to work with.}

\item{row}{row in the table (1 is top row), including
rows of labels.}

\item{withExtras}{If \code{TRUE}, include the extras
before the line of data, such as \verb{\\hline}, etc.}

\item{withData}{If \code{TRUE}, include the data.}

\item{asis}{Should a linebreak and newline be added after the
value?}

\item{value}{The content to be inserted into the cell.  This
can be a \link{LaTeX2} object, or a character string that will be
converted to one.}
}
\value{
\code{find_tableRow()} returns a \link{LaTeX2range} of
the entries corresponding to the content of row i of
the table.

\code{tableRow()} returns a \link{LaTeX2} object containing
all of the table content in the row.
}
\description{
Functions to work with rows in tables
}
\details{
Unless \code{asis = TRUE}, \code{tableContent(table) <- value}
will add "\\" and a newline
at the end if not present.

If the \code{row} value is higher than the number of rows
in the table, blank rows will be added to fill the
space between.

If \code{withExtras = TRUE} and you want the
result to start on a new line, you need to add the
newline explicitly in \code{value} when using the
assignment function.
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex")
parsed <- parseLatex(latex)
table <- parsed[[find_tabular(parsed)]]
find_tableRow(table, 1)

tableRow(table, 1)
tableRow(table, 1, withExtras = TRUE)

tableRow(table, 5) <- "a & b & c"
table

}
