% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_tag_resource}
\alias{costexplorer_tag_resource}
\title{An API operation for adding one or more tags (key-value pairs) to a
resource}
\usage{
costexplorer_tag_resource(ResourceArn, ResourceTags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource. For a list of supported
resources, see
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html}{ResourceTag}.}

\item{ResourceTags}{[required] A list of tag key-value pairs to be added to the resource.

Each tag consists of a key and a value, and each key must be unique for
the resource. The following restrictions apply to resource tags:
\itemize{
\item Although the maximum number of array members is 200, you can assign
a maximum of 50 user-tags to one resource. The remaining are
reserved for Amazon Web Services use
\item The maximum length of a key is 128 characters
\item The maximum length of a value is 256 characters
\item Keys and values can only contain alphanumeric characters, spaces,
and any of the following: \verb{_.:/=+@-}
\item Keys and values are case sensitive
\item Keys and values are trimmed for any leading or trailing whitespaces
\item Don’t use \verb{aws:} as a prefix for your keys. This prefix is reserved
for Amazon Web Services use
}}
}
\description{
An API operation for adding one or more tags (key-value pairs) to a resource.

See \url{https://www.paws-r-sdk.com/docs/costexplorer_tag_resource/} for full documentation.
}
\keyword{internal}
