% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_create_project}
\alias{codebuild_create_project}
\title{Creates a build project}
\usage{
codebuild_create_project(
  name,
  description = NULL,
  source,
  secondarySources = NULL,
  sourceVersion = NULL,
  secondarySourceVersions = NULL,
  artifacts,
  secondaryArtifacts = NULL,
  cache = NULL,
  environment,
  serviceRole,
  timeoutInMinutes = NULL,
  queuedTimeoutInMinutes = NULL,
  encryptionKey = NULL,
  tags = NULL,
  vpcConfig = NULL,
  badgeEnabled = NULL,
  logsConfig = NULL,
  fileSystemLocations = NULL,
  buildBatchConfig = NULL,
  concurrentBuildLimit = NULL,
  autoRetryLimit = NULL
)
}
\arguments{
\item{name}{[required] The name of the build project.}

\item{description}{A description that makes the build project easy to identify.}

\item{source}{[required] Information about the build input source code for the build project.}

\item{secondarySources}{An array of \code{ProjectSource} objects.}

\item{sourceVersion}{A version of the build input to be built for this project. If not
specified, the latest version is used. If specified, it must be one of:
\itemize{
\item For CodeCommit: the commit ID, branch, or Git tag to use.
\item For GitHub: the commit ID, pull request ID, branch name, or tag name
that corresponds to the version of the source code you want to
build. If a pull request ID is specified, it must use the format
\code{pr/pull-request-ID} (for example \code{pr/25}). If a branch name is
specified, the branch's HEAD commit ID is used. If not specified,
the default branch's HEAD commit ID is used.
\item For GitLab: the commit ID, branch, or Git tag to use.
\item For Bitbucket: the commit ID, branch name, or tag name that
corresponds to the version of the source code you want to build. If
a branch name is specified, the branch's HEAD commit ID is used. If
not specified, the default branch's HEAD commit ID is used.
\item For Amazon S3: the version ID of the object that represents the
build input ZIP file to use.
}

If \code{sourceVersion} is specified at the build level, then that version
takes precedence over this \code{sourceVersion} (at the project level).

For more information, see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html}{Source Version Sample with CodeBuild}
in the \emph{CodeBuild User Guide}.}

\item{secondarySourceVersions}{An array of \code{ProjectSourceVersion} objects. If \code{secondarySourceVersions}
is specified at the build level, then they take precedence over these
\code{secondarySourceVersions} (at the project level).}

\item{artifacts}{[required] Information about the build output artifacts for the build project.}

\item{secondaryArtifacts}{An array of \code{ProjectArtifacts} objects.}

\item{cache}{Stores recently used information so that it can be quickly accessed at a
later time.}

\item{environment}{[required] Information about the build environment for the build project.}

\item{serviceRole}{[required] The ARN of the IAM role that enables CodeBuild to interact with
dependent Amazon Web Services services on behalf of the Amazon Web
Services account.}

\item{timeoutInMinutes}{How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait
before it times out any build that has not been marked as completed. The
default is 60 minutes.}

\item{queuedTimeoutInMinutes}{The number of minutes a build is allowed to be queued before it times
out.}

\item{encryptionKey}{The Key Management Service customer master key (CMK) to be used for
encrypting the build output artifacts.

You can use a cross-account KMS key to encrypt the build output
artifacts if your service role has permission to that key.

You can specify either the Amazon Resource Name (ARN) of the CMK or, if
available, the CMK's alias (using the format \verb{alias/<alias-name>}).}

\item{tags}{A list of tag key and value pairs associated with this build project.

These tags are available for use by Amazon Web Services services that
support CodeBuild build project tags.}

\item{vpcConfig}{VpcConfig enables CodeBuild to access resources in an Amazon VPC.

If you're using compute fleets during project creation, do not provide
vpcConfig.}

\item{badgeEnabled}{Set this to true to generate a publicly accessible URL for your
project's build badge.}

\item{logsConfig}{Information about logs for the build project. These can be logs in
CloudWatch Logs, logs uploaded to a specified S3 bucket, or both.}

\item{fileSystemLocations}{An array of \code{ProjectFileSystemLocation} objects for a CodeBuild build
project. A \code{ProjectFileSystemLocation} object specifies the
\code{identifier}, \code{location}, \code{mountOptions}, \code{mountPoint}, and \code{type} of a
file system created using Amazon Elastic File System.}

\item{buildBatchConfig}{A ProjectBuildBatchConfig object that defines the batch build options
for the project.}

\item{concurrentBuildLimit}{The maximum number of concurrent builds that are allowed for this
project.

New builds are only started if the current number of builds is less than
or equal to this limit. If the current build count meets this limit, new
builds are throttled and are not run.}

\item{autoRetryLimit}{The maximum number of additional automatic retries after a failed build.
For example, if the auto-retry limit is set to 2, CodeBuild will call
the \code{\link[=codebuild_retry_build]{retry_build}} API to automatically retry
your build for up to 2 additional times.}
}
\description{
Creates a build project.

See \url{https://www.paws-r-sdk.com/docs/codebuild_create_project/} for full documentation.
}
\keyword{internal}
