% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_get_link_attributes}
\alias{clouddirectory_get_link_attributes}
\title{Retrieves attributes that are associated with a typed link}
\usage{
clouddirectory_get_link_attributes(
  DirectoryArn,
  TypedLinkSpecifier,
  AttributeNames,
  ConsistencyLevel = NULL
)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where the typed link resides. For more information, see arns or \href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink}{Typed Links}.}

\item{TypedLinkSpecifier}{[required] Allows a typed link specifier to be accepted as input.}

\item{AttributeNames}{[required] A list of attribute names whose values will be retrieved.}

\item{ConsistencyLevel}{The consistency level at which to retrieve the attributes on a typed
link.}
}
\description{
Retrieves attributes that are associated with a typed link.

See \url{https://www.paws-r-sdk.com/docs/clouddirectory_get_link_attributes/} for full documentation.
}
\keyword{internal}
