% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_filter}
\alias{guardduty_create_filter}
\title{Creates a filter using the specified finding criteria}
\usage{
guardduty_create_filter(
  DetectorId,
  Name,
  Description = NULL,
  Action = NULL,
  Rank = NULL,
  FindingCriteria,
  ClientToken = NULL,
  Tags = NULL
)
}
\arguments{
\item{DetectorId}{[required] The detector ID associated with the GuardDuty account for which you want
to create a filter.

To find the \code{detectorId} in the current Region, see the Settings page in
the GuardDuty console, or run the
\code{\link[=guardduty_list_detectors]{list_detectors}} API.}

\item{Name}{[required] The name of the filter. Valid characters include period (.), underscore
(_), dash (-), and alphanumeric characters. A whitespace is considered
to be an invalid character.}

\item{Description}{The description of the filter. Valid characters include alphanumeric
characters, and special characters such as hyphen, period, colon,
underscore, parentheses (\code{{ }}, \verb{[ ]}, and \verb{( )}), forward slash,
horizontal tab, vertical tab, newline, form feed, return, and
whitespace.

[ ]: R:\%20}

\item{Action}{Specifies the action that is to be applied to the findings that match
the filter.}

\item{Rank}{Specifies the position of the filter in the list of current filters.
Also specifies the order in which this filter is applied to the
findings.}

\item{FindingCriteria}{[required] Represents the criteria to be used in the filter for querying findings.

You can only use the following attributes to query findings:
\itemize{
\item accountId
\item id
\item region
\item severity

To filter on the basis of severity, the API and CLI use the
following input list for the
\href{https://docs.aws.amazon.com/guardduty/latest/APIReference/API_FindingCriteria.html}{FindingCriteria}
condition:
\itemize{
\item \strong{Low}: \verb{["1", "2", "3"]}
\item \strong{Medium}: \verb{["4", "5", "6"]}
\item \strong{High}: \verb{["7", "8"]}
\item \strong{Critical}: \verb{["9", "10"]}
}

For more information, see \href{https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings-severity.html}{Findings severity levels}
in the \emph{Amazon GuardDuty User Guide}.
\item type
\item updatedAt

Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or
YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains
milliseconds.
\item resource.accessKeyDetails.accessKeyId
\item resource.accessKeyDetails.principalId
\item resource.accessKeyDetails.userName
\item resource.accessKeyDetails.userType
\item resource.instanceDetails.iamInstanceProfile.id
\item resource.instanceDetails.imageId
\item resource.instanceDetails.instanceId
\item resource.instanceDetails.tags.key
\item resource.instanceDetails.tags.value
\item resource.instanceDetails.networkInterfaces.ipv6Addresses
\item resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
\item resource.instanceDetails.networkInterfaces.publicDnsName
\item resource.instanceDetails.networkInterfaces.publicIp
\item resource.instanceDetails.networkInterfaces.securityGroups.groupId
\item resource.instanceDetails.networkInterfaces.securityGroups.groupName
\item resource.instanceDetails.networkInterfaces.subnetId
\item resource.instanceDetails.networkInterfaces.vpcId
\item resource.instanceDetails.outpostArn
\item resource.resourceType
\item resource.s3BucketDetails.publicAccess.effectivePermissions
\item resource.s3BucketDetails.name
\item resource.s3BucketDetails.tags.key
\item resource.s3BucketDetails.tags.value
\item resource.s3BucketDetails.type
\item service.action.actionType
\item service.action.awsApiCallAction.api
\item service.action.awsApiCallAction.callerType
\item service.action.awsApiCallAction.errorCode
\item service.action.awsApiCallAction.remoteIpDetails.city.cityName
\item service.action.awsApiCallAction.remoteIpDetails.country.countryName
\item service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
\item service.action.awsApiCallAction.remoteIpDetails.ipAddressV6
\item service.action.awsApiCallAction.remoteIpDetails.organization.asn
\item service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
\item service.action.awsApiCallAction.serviceName
\item service.action.dnsRequestAction.domain
\item service.action.dnsRequestAction.domainWithSuffix
\item service.action.networkConnectionAction.blocked
\item service.action.networkConnectionAction.connectionDirection
\item service.action.networkConnectionAction.localPortDetails.port
\item service.action.networkConnectionAction.protocol
\item service.action.networkConnectionAction.remoteIpDetails.city.cityName
\item service.action.networkConnectionAction.remoteIpDetails.country.countryName
\item service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
\item service.action.networkConnectionAction.remoteIpDetails.ipAddressV6
\item service.action.networkConnectionAction.remoteIpDetails.organization.asn
\item service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
\item service.action.networkConnectionAction.remotePortDetails.port
\item service.action.awsApiCallAction.remoteAccountDetails.affiliated
\item service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4
\item service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6
\item service.action.kubernetesApiCallAction.namespace
\item service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn
\item service.action.kubernetesApiCallAction.requestUri
\item service.action.kubernetesApiCallAction.statusCode
\item service.action.networkConnectionAction.localIpDetails.ipAddressV4
\item service.action.networkConnectionAction.localIpDetails.ipAddressV6
\item service.action.networkConnectionAction.protocol
\item service.action.awsApiCallAction.serviceName
\item service.action.awsApiCallAction.remoteAccountDetails.accountId
\item service.additionalInfo.threatListName
\item service.resourceRole
\item resource.eksClusterDetails.name
\item resource.kubernetesDetails.kubernetesWorkloadDetails.name
\item resource.kubernetesDetails.kubernetesWorkloadDetails.namespace
\item resource.kubernetesDetails.kubernetesUserDetails.username
\item resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image
\item resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix
\item service.ebsVolumeScanDetails.scanId
\item service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name
\item service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity
\item service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash
\item resource.ecsClusterDetails.name
\item resource.ecsClusterDetails.taskDetails.containers.image
\item resource.ecsClusterDetails.taskDetails.definitionArn
\item resource.containerDetails.image
\item resource.rdsDbInstanceDetails.dbInstanceIdentifier
\item resource.rdsDbInstanceDetails.dbClusterIdentifier
\item resource.rdsDbInstanceDetails.engine
\item resource.rdsDbUserDetails.user
\item resource.rdsDbInstanceDetails.tags.key
\item resource.rdsDbInstanceDetails.tags.value
\item service.runtimeDetails.process.executableSha256
\item service.runtimeDetails.process.name
\item service.runtimeDetails.process.executablePath
\item resource.lambdaDetails.functionName
\item resource.lambdaDetails.functionArn
\item resource.lambdaDetails.tags.key
\item resource.lambdaDetails.tags.value
}}

\item{ClientToken}{The idempotency token for the create request.}

\item{Tags}{The tags to be added to a new filter resource.}
}
\description{
Creates a filter using the specified finding criteria. The maximum number of saved filters per Amazon Web Services account per Region is 100. For more information, see \href{https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_limits.html}{Quotas for GuardDuty}.

See \url{https://www.paws-r-sdk.com/docs/guardduty_create_filter/} for full documentation.
}
\keyword{internal}
