% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfcombiner.R
\name{pdfcombiner}
\alias{pdfcombiner}
\title{Launches PDF Combiner}
\usage{
pdfcombiner(
  max_file_size = 500,
  bootstrap_theme = TRUE,
  sidebar_width = 700,
  defaultwm_fontsize = 50,
  defaultwm_col = "gray80",
  defaultwm_alpha = 0.6,
  defaultwm_rot = 45,
  defaultwm_fontface = "bold",
  defaultwm_height = 11,
  defaultwm_width = 8.5,
  image_dpi = 300,
  compact_level = "ebook",
  linearize = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{max_file_size}{Max upload file size in MB, change if needed}

\item{bootstrap_theme}{When TRUE, uses bslib bootstrap theme to allow minimizing sidebar}

\item{sidebar_width}{Only applicable when bootstrap theme is used, in pixels}

\item{defaultwm_fontsize}{Default Watermark font size}

\item{defaultwm_col}{Default Watermark color}

\item{defaultwm_alpha}{Default Watermark alpha}

\item{defaultwm_rot}{Default Watermark rotation angle}

\item{defaultwm_fontface}{Default Watermark fontface (one of "plain", "italic", "bold", "bold.italic")}

\item{defaultwm_height}{Default Watermark height in inches (US letter size = 11,  A4 = 11.69)}

\item{defaultwm_width}{Default Watermark width in inches (US letter size = 8.5, A4 = 8.27)}

\item{image_dpi}{Dots per inch for use when converting to images}

\item{compact_level}{One of "none" (not used), "printer" (300dpi), "ebook" (150dpi), "screen" (72dpi), only applicable if Ghostscript is installed}

\item{linearize}{Default FALSE. When TRUE, optimizes PDF for web-viewing (loads first page quickly)}

\item{verbose}{Prints out working messages in console}
}
\value{
a Shiny App
}
\description{
Launches the PDF Combiner \link[shiny]{shiny} App. Instructions on usage are
included on the left hand side of the page. By default it uses the bootstrap theme,
allowing minimization of the sidebar. Set argument \code{boostrap_theme = FALSE} to turn this
off.
}
\details{
The user is highly recommended to also install the \link[staplr]{staplr} package as it supports bookmarks, however
it uses Java so you may need to install Java separately if your system does not currently have it.
In addition, the \link[magick]{magick} package is recommended for supporting uploading of image files.
}
\note{
All PDF files are stored locally in a per-session temporary directory, given by the \code{tempdir()} function.
}
\examples{
if (interactive()) {
pdfcombiner(bootstrap_theme = FALSE) # Do not use bootstrap theme (if `shiny` version is < 1.7.4)
}
}
\seealso{
\url{https://github.com/stevechoy/pdfcombiner}, \link[pdftools]{pdftools}, \link[qpdf]{qpdf}
}
