% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_access.R
\name{pm_backbone_info}
\alias{pm_backbone_info}
\title{Display taxonomic backbone metadata for Peruvian mammals}
\usage{
pm_backbone_info()
}
\value{
Invisibly returns a tibble with one row containing the backbone
metadata. The same structure as \code{\link{peru_mammals_backbone}}.
Called primarily for its side effect of printing the summary information.
}
\description{
Displays summary information about the taxonomic backbone used in
\pkg{perumammals}. The backbone is based on the taxonomic checklist
published by Pacheco et al. (2021), which was digitised from the original
PDF publication into a structured tibble format.
}
\examples{
# Display backbone information
pm_backbone_info()

# Access the data invisibly returned
backbone_data <- pm_backbone_info()
backbone_data$n_species

}
\references{
Pacheco Torres, V. R., Diaz, S., Graham Angeles, L. A., Flores-Quispe, M.,
Calizaya-Mamani, G., Ruelas, D., & Sánchez-Vendizú, P. (2021). Lista
actualizada de la diversidad de los mamíferos del Perú y una propuesta para
su actualización. \emph{Revista Peruana De Biología}, \strong{28}(4),
e21019. \doi{10.15381/rpb.v28i4.21019}
}
\seealso{
\code{\link{peru_mammals_backbone}} for the complete backbone data.
}
