% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{get_nested_model}
\alias{get_nested_model}
\title{get_nested_model}
\usage{
get_nested_model(model_1, model_2)
}
\arguments{
\item{model_1}{(Model) Pharmpy model object}

\item{model_2}{(Model) Pharmpy model object}
}
\value{
(Model | NULL) Pharmpy model object or NULL
}
\description{
Return nested model from a pair of models

Function to get a nested model from a pair of models, NULL
if neither model is nested. A model is not considered nested if:
\enumerate{
\item They are the same model
\item They have the same number of parameters
\item The parameters of the reduced model is not a subset of
the extended model
\item The dosing or DV is changed
}

Assumptions made:
\enumerate{
\item Parametrization is the same
\item Parameter names are the same
}
}
\examples{
\dontrun{
model_1 <- load_example_model("pheno")
model_2 <- add_peripheral_compartment(model_1)
model_2 <- set_name(model_2, 'pheno_2')
nested <- get_nested_model(model_1, model_2)
nested$name
}

}
