% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.new.r
\name{source_spct}
\alias{source_spct}
\alias{calibration_spct}
\alias{raw_spct}
\alias{cps_spct}
\alias{generic_spct}
\alias{response_spct}
\alias{filter_spct}
\alias{reflector_spct}
\alias{solute_spct}
\alias{object_spct}
\alias{chroma_spct}
\title{Spectral-object constructors}
\usage{
source_spct(
  w.length = NULL,
  s.e.irrad = NULL,
  s.q.irrad = NULL,
  ...,
  time.unit = c("second", "day", "exposure"),
  bswf.used = c("none", "unknown"),
  comment = NULL,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

calibration_spct(
  w.length = NULL,
  irrad.mult = NA_real_,
  ...,
  comment = NULL,
  instr.desc = NA,
  multiple.wl = 1L,
  idfactor = NULL
)

raw_spct(
  w.length = NULL,
  counts = NA_real_,
  ...,
  comment = NULL,
  instr.desc = NA,
  instr.settings = NA,
  multiple.wl = 1L,
  idfactor = NULL
)

cps_spct(
  w.length = NULL,
  cps = NA_real_,
  ...,
  comment = NULL,
  instr.desc = NA,
  instr.settings = NA,
  multiple.wl = 1L,
  idfactor = NULL
)

generic_spct(
  w.length = NULL,
  ...,
  comment = NULL,
  multiple.wl = 1L,
  idfactor = NULL
)

response_spct(
  w.length = NULL,
  s.e.response = NULL,
  s.q.response = NULL,
  ...,
  time.unit = c("second", "day", "exposure"),
  response.type = c("response", "action"),
  comment = NULL,
  multiple.wl = 1L,
  idfactor = NULL
)

filter_spct(
  w.length = NULL,
  Tfr = NULL,
  Tpc = NULL,
  Afr = NULL,
  A = NULL,
  ...,
  Tfr.type = c("total", "internal"),
  Rfr.constant = NA_real_,
  thickness = NA_real_,
  attenuation.mode = NA,
  comment = NULL,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

reflector_spct(
  w.length = NULL,
  Rfr = NULL,
  Rpc = NULL,
  ...,
  Rfr.type = c("total", "specular"),
  comment = NULL,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

solute_spct(
  w.length = NULL,
  K.mole = NULL,
  K.mass = NULL,
  attenuation.XS = NULL,
  ...,
  log.base = 10,
  K.type = c("attenuation", "absorption", "scattering"),
  name = NA_character_,
  mass = NA_character_,
  formula = NULL,
  structure = grDevices::as.raster(matrix()),
  ID = NA_character_,
  solvent.name = NA_character_,
  solvent.ID = NA_character_,
  comment = NULL,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

object_spct(
  w.length = NULL,
  Rfr = NULL,
  Tfr = NULL,
  Afr = NULL,
  ...,
  Tfr.type = c("total", "internal"),
  Rfr.type = c("total", "specular"),
  comment = NULL,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)

chroma_spct(
  w.length = NULL,
  x,
  y,
  z,
  ...,
  comment = NULL,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = 1L,
  idfactor = NULL
)
}
\arguments{
\item{w.length}{numeric vector with wavelengths in nanometres [\eqn{nm}].}

\item{s.e.irrad}{numeric vector with spectral energy irradiance in
[\eqn{W\,m^{-2}\,nm^{-1}}] or [\eqn{J\,d^{-1}\,m^{-2}\,nm^{-1}}{J d-1 m-2 nm-1}].}

\item{s.q.irrad}{numeric A vector with spectral photon irradiance in
[\eqn{mol\,s^{-1}\,m^{-2}\,nm^{-1}}{mol s-1 m-2 nm-1}] or
[\eqn{mol\,d^{-1}\,m^{-2}\,nm^{-1}}{mol d-1 m-2 nm-1}].}

\item{...}{other arguments passed to \code{tibble()} such as vectors or
factors to be added as additional columns.}

\item{time.unit}{character string indicating the time unit used for spectral
irradiance or exposure (\code{"second"}, \code{"day"} or \code{"exposure"})
or an object of class duration as defined in package lubridate.}

\item{bswf.used}{character A string indicating the BSWF used, if any, for
spectral effective irradiance or exposure (\code{"none"} or the name of the
BSWF).}

\item{comment}{character A string to be added as a comment attribute to the
object created.}

\item{strict.range}{logical Flag indicating whether off-range values result
in an error instead of a warning.}

\item{multiple.wl}{numeric Maximum number of repeated \code{w.length} entries
with same value. (As with multiple spectra stored in long from).}

\item{idfactor}{character Name of factor distinguishing multiple spectra when
stored longitudinally (required if \code{multiple.wl} > 1).}

\item{irrad.mult}{numeric vector with multipliers for each detector pixel
expressed in units of \eqn{W\,m^{-2}\,nm^{-1}\,n^{-1}\,s}{W m-2 nm-1 n-1 s},
where \eqn{n\,s^{-1}}{n s-1} are detector counts per second.}

\item{instr.desc}{a list describing the spectrometer used to acquire the data.}

\item{counts}{numeric vector with raw counts expressed per scan.}

\item{instr.settings}{a list describing the settings used to acquire the data.}

\item{cps}{numeric vector with linearized raw counts expressed per second
[\eqn{n\,s^{-1}}{n s-1}]}

\item{s.e.response}{numeric vector with a biological, chemical or physical
response expressed per unit spectral energy irradiance
[\eqn{W\,m^{-2}\,nm^{-1}}{W m-2 nm-1} or \eqn{J\,d^{-1}\,m^{-2}\,nm^{-1}}{J d-1 m-2 nm-1}].}

\item{s.q.response}{numeric vector with a biological, chemical or physical
response expressed per unit spectral photon irradiance in
[\eqn{mol\,s^{-1}\,m^{-2}\,nm^{-1}}{mol s-1 m-2 nm-1} or \eqn{mol\,d^{-1}\,m^{-2}\,nm^{-1}}{mol d-1 m-2 nm-1}].}

\item{response.type}{a character string, either \code{"response"} or
\code{"action"}.}

\item{Tfr}{numeric vector with spectral transmittance as fraction of one
[\eqn{/1}].}

\item{Tpc}{numeric vector with spectral transmittance as percent values}

\item{Afr}{numeric vector of absorptance as fraction of one [\eqn{/1}].}

\item{A}{numeric vector of absorbance values (\eqn{log_{10}}{log10}-base
a.u.)}

\item{Tfr.type}{character string indicating whether transmittance and
absorptance values are \code{"total"} or \code{"internal"} values}

\item{Rfr.constant}{numeric The value of the reflection factor [\eqn{/1}].}

\item{thickness}{numeric The thickness of the material.}

\item{attenuation.mode}{character One of \code{"reflection"},
\code{"absorption"} or \code{"mixed"}.}

\item{Rfr}{numeric vector with spectral reflectance as fraction of one
[\eqn{/1}].}

\item{Rpc}{numeric vector with spectral reflectance as percent values.}

\item{Rfr.type}{character A string, either \code{"total"} or
\code{"specular"}.}

\item{K.mole}{numeric vector with molar attenuation coefficient in SI units
[\eqn{m^2\,mol^-1}{m2 mol-1}].}

\item{K.mass}{numeric vector with mass attenuation coefficient in SI units
[\eqn{m^2\,g^-1}{m2 g-1}].}

\item{attenuation.XS}{numeric vector with attenuation cross section values
(Converted during object construction into \code{K.mole}.)}

\item{log.base}{numeric Normally one of \code{e} or \code{10}. Data are
stored always on base 10 corresponding to decadal absorbance as used in
chemistry.}

\item{K.type}{character A string, either \code{"attenuation"},
\code{"absorption"} or \code{"scattering"}.}

\item{name, solvent.name}{character The names of the substance and of the
solvent. A named character vector, with member names such as "IUPAC" for
the authority.}

\item{mass}{numeric The molar mass in Dalton [Da] (\eqn{Da = g\,mol^{-1}}{Da = g mol-1}).}

\item{formula}{character The molecular formula.}

\item{structure}{raster A bitmap of the structure.}

\item{ID, solvent.ID}{character The ID of the substance and of the solvent. A
named character vector, with member names such as "ChemSpider" or "PubChem"
for the authority.}

\item{x, y, z}{numeric colour coordinates}
}
\value{
A object of class \code{generic_spct} or a class derived from it,
  depending on the function used. In other words an object of a class with
  the same name as the constructor function.
}
\description{
These constructor functions can be used to create spectral objects derived
from \code{generic_spct}. They take as arguments numeric vectors for the
wavelengths and spectral data, and numeric, character, and logical values for
metadata attributes to be saved to the objects created and options
controlling the creation process.
}
\details{
Constructors can be used to create spectral objects from spectral
  quantities expressed on a single base or unit. Some of the functions have
  different formal parameters accepting a quantity expressed in different
  units, however, an argument can be passed to only one of these formal
  parameters in a given call. The constructors \code{object_spct()} and
  \code{chroma_spct()} require arguments to be passed for multiple but
  distinct spectral quantities.
}
\section{Warning for filter_spct!}{
 Not entering metadata when creating an
  object will limit the available operations! While "internal" transmittance
  is defined as the transmittance of the material body itself, "total"
  transmittance includes the effects of surface reflectance on the amount of
  light transmitted. For non-diffusing materials like glass an approximate
  \code{Rfr.constant} value can be used to convert "total" into "internal"
  transmittance values and vice versa. Use \code{NA} if not known, or not
  applicable, e.g., for materials subject to internal scattering.
}

\section{Warning for solute_spct!}{

  You should always set the base for logarithms to match that on which the
  absorbance data are expressed. Failing to do this will result in bad data
  and all further computation will be wrong. Not entering metadata when
  creating an object will limit the available operations! Mass should be
  indicated in daltons or \eqn{g\,mol^{-1}}{g mol-1}. The SI unit of molar attenuation
  coefficient is the square metre per mole (\eqn{m^2\,mol^{1}}{m2 mol-1}),
  but in practice, quantities are usually expressed in terms of
  \eqn{M^{-1}\,cm^{-1}} or \eqn{l\,mol^{-1}\,cm^{-1}} (the latter two units are
  both equal to 0.1 \eqn{m^2\,mol^{-1}} and quantities expressed in them need
  to be divided by 10 when passed as arguments to \code{K.mole}.).
}

\seealso{
\code{\link{setFilterProperties}}

\code{\link{setSoluteProperties}}

Other constructors of spectral objects: 
\code{\link{as.calibration_spct}()},
\code{\link{as.chroma_spct}()},
\code{\link{as.cps_spct}()},
\code{\link{as.filter_spct}()},
\code{\link{as.generic_spct}()},
\code{\link{as.object_spct}()},
\code{\link{as.raw_spct}()},
\code{\link{as.reflector_spct}()},
\code{\link{as.response_spct}()},
\code{\link{as.solute_spct}()},
\code{\link{as.source_spct}()}
}
\concept{constructors of spectral objects}
