% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.summaries.r
\name{summary.generic_spct}
\alias{summary.generic_spct}
\alias{summary.generic_mspct}
\title{Summary of one or more spectra}
\usage{
\method{summary}{generic_spct}(
  object,
  maxsum = 7,
  digits = max(3, getOption("digits") - 3),
  ...,
  expand = "none"
)

\method{summary}{generic_mspct}(
  object,
  maxsum = 7,
  digits = max(3, getOption("digits") - 3),
  idx = "spct.idx",
  which.metadata = NULL,
  expand = "none",
  ...
)
}
\arguments{
\item{object}{An object of one of the spectral classes for which a summary is
desired.}

\item{maxsum}{integer Indicates how many levels should be shown for factors.}

\item{digits}{integer Used for number formatting with \code{\link{format}()}.}

\item{...}{additional arguments affecting the summary produced, ignored in
current version.}

\item{expand}{character One of \code{"none"}, \code{"collection"},
\code{"each"} or \code{"auto"} indicating if multiple spectra in long form
should be summarized as a collection or individually.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{which.metadata}{character vector Names of attributes to retrieve, or
"none" or "all". Obeyed if \code{expand = "collection"}, its default.}
}
\value{
A summary object matching the class of \code{object}, or a list of
  such objects or a summary object for a matching collection of spectra.
  Metadata stored in attributes are copied to identical attributes in the
  returned summary objects except when \code{object} is a collection
  of spectra or if \code{expand = "collection"} is passed in the call. In
  this two cases, a condensed summary is returned as a data frame and
  attributes from each member can be copied to variables in it.
}
\description{
Methods of generic function summary for objects of spectral classes and
of classes for collections of spectra.
}
\details{
Objects are summarized as is, ignoring the current settings of R options
\code{photobiology.radiation.unit} and \code{photobiology.filter.qty}. Unlike
R's summary, these methods can optionally summarize each spectrum stored in
long form returning a list of summaries. Although this is frequently the most
informative approach, the default remains similar to \code{summary()} method
from R: to summarize \code{object} as a whole. Alternatively, multiple
spectra stored in long form, can optionally be summarized also as a
collection of spectra. Passing \code{"auto"} in the call, is equivalent to
passing \code{"each"} or \code{"collection"} depending on the number of
spectra contained in the object.
}
\section{Functions}{
\itemize{
\item \code{summary(generic_mspct)}: 

}}
\examples{
summary(sun.spct)
class(summary(sun.spct))

summary(two_filters.spct)
class(summary(two_filters.spct))

summary(sun_evening.spct)
summary(two_filters.spct, expand = "none")
summary(two_filters.spct, expand = "each")
summary(two_filters.spct, expand = "collection")
summary(two_filters.spct, expand = "auto") # <= 4 spectra
summary(sun_evening.spct, expand = "auto") # > 4 spectra

where_measured(sun.spct)
where_measured(summary(sun.spct))
what_measured(summary(two_filters.spct))
what_measured(summary(two_filters.spct, expand = "each")[[1]])

summary(sun_evening.mspct)
summary(sun_evening.mspct, which.metadata = "when.measured")
summary(two_filters.mspct, which.metadata = "what.measured")
summary(two_filters.mspct, expand = "each")

}
\seealso{
\code{\link[photobiology]{print.summary_generic_spct}}
}
