% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{pairwise-distances}
\alias{pairwise-distances}
\alias{bottleneck_pairwise_distances}
\alias{wasserstein_pairwise_distances}
\alias{kantorovich_pairwise_distances}
\title{Pairwise distances within a set of persistence diagrams}
\usage{
bottleneck_pairwise_distances(
  x,
  tol = sqrt(.Machine$double.eps),
  validate = TRUE,
  dimension = 0L,
  ncores = 1L
)

wasserstein_pairwise_distances(
  x,
  tol = sqrt(.Machine$double.eps),
  p = 1,
  validate = TRUE,
  dimension = 0L,
  ncores = 1L
)

kantorovich_pairwise_distances(
  x,
  tol = sqrt(.Machine$double.eps),
  p = 1,
  validate = TRUE,
  dimension = 0L,
  ncores = 1L
)
}
\arguments{
\item{x}{A list of either 2-column matrices or objects of class \link{persistence}
specifying the set of persistence diagrams.}

\item{tol}{A numeric value specifying the relative error. Defaults to
\code{sqrt(.Machine$double.eps)}. For the Bottleneck distance, it can be set to
\code{0.0} in which case the exact Bottleneck distance is computed, while an
approximate Bottleneck distance is computed if \code{tol > 0.0}. For the
Wasserstein distance, it must be strictly positive.}

\item{validate}{A boolean value specifying whether to validate the input
persistence diagrams. Defaults to \code{TRUE}. If \code{FALSE}, the function will not
check if the input persistence diagrams are valid. This can be useful for
performance reasons, but it is recommended to keep it \code{TRUE} for safety.}

\item{dimension}{An integer value specifying the homology dimension for which
to compute the distance. Defaults to \code{0L}. This is only used if \code{x} and \code{y}
are objects of class \link{persistence}.}

\item{ncores}{An integer value specifying the number of cores to use for
parallel computation. Defaults to \code{1L}.}

\item{p}{A numeric value specifying the power for the Wasserstein distance.
Defaults to \code{1.0}.}
}
\value{
An object of class 'dist' containing the pairwise distance matrix
between the persistence diagrams.
}
\description{
This collection of functions computes the pairwise distance matrix between
all pairs in a set of persistence diagrams of the same homology dimension.
The diagrams must be represented as 2-column matrices. The first column of
the matrix contains the birth times and the second column contains the death
times of the points.
}
\examples{
spl <- persistence_sample[1:10]

# Extract the list of 2-column matrices for dimension 0 in the sample
x <- lapply(spl[1:10], function(x) x$pairs[[1]])

# Compute the pairwise Bottleneck distances
Db <- bottleneck_pairwise_distances(spl)
Db <- bottleneck_pairwise_distances(x)

# Compute the pairwise Wasserstein distances
Dw <- wasserstein_pairwise_distances(spl)
Dw <- wasserstein_pairwise_distances(x)

}
