% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloregion-package.R
\docType{data}
\name{africa}
\alias{africa}
\title{Plants of southern Africa}
\description{
This dataset consists of a dated phylogeny of the woody plant
species of southern Africa along with their geographical distributions.
The dataset comes from a study that maps tree diversity hotspots in southern Africa
(Daru et al. 2015). The study mapped five types of diversity hotspots including
species richness (SR), phylogenetic diversity (PD), phylogenetic endemism
(PE), species weighted endemism (CWE), and evolutionary distinctiveness and
global endangerment (EDGE). The results revealed large spatial incongruence
between biodiversity indices, resulting in unequal representation of PD,
SR, PE, CWE and EDGE in hotspots and currently protected areas, suggesting
that an integrative approach which considers multiple facets of biodiversity
is needed to maximise the conservation of tree diversity in southern Africa.
Specifically for this package, we arranged the dataset into four components:
\dQuote{comm}, \dQuote{polys}, \dQuote{phylo}, \dQuote{mat}, \dQuote{IUCN}.
}
\section{Details}{

\itemize{
  \item comm: This is a sparse community composition matrix of each species
  presences/absences within 50 × 50 km grid cells. A sparse matrix is a
  matrix with a high proportion of zero entries (Duff 1977), of which only
  the non-zero entries are stored and used for downstream analysis.
  \item polys: These are the grid cells covering the geographic extent of
  study area. These can be created using the function \code{\link{fishnet}}.
  The polys object is of class \code{SpatVector} and has a column labeled
  \dQuote{grids}, with the grid identities.
   \item phylo: This corresponds to the phylogenetic tree which was
   estimated using Bayesian analysis of 1,400 species and 1,633 bp
   of chloroplast DNA sequences derived from a combination of  \emph{matK}
   and  \emph{rbcLa}, assuming an uncorrelated relaxed molecular clock model,
   using the program BEAST v.1.7.5 (Drummond & Rambaut, 2007). Branch
   lengths were calibrated in millions of years using a Bayesian MCMC
   approach by enforcing topological constraints assuming APG III backbone
   from Phylomatic v.3 (Webb & Donoghue, 2005) and 18 fossil calibration
   points from Bell et al. (2010).
   \item mat: This is a distance matrix of phylogenetic beta diversity
   between all grid cells at the 50 × 50 km scale.
   \item IUCN: This is a dataframe of IUCN conservation status of each woody
   species (LC, NT, VU, EN, CR). This is useful for analysis of Evolutionary
   Distinctiveness and Global Endangerment using the function
   \code{\link{EDGE}}.
}
}

\examples{
data(africa)
names(africa)
\donttest{
library(terra)
library(ape)
plot(africa$phylo)
}
}
\references{
Bell, C.D., Soltis, D.E., & Soltis, P.S. (2010). The age and diversification
of the angiosperms re-revisited. \emph{American Journal of Botany}
\strong{97}, 1296–1303.

Daru, B.H., Van der Bank, M. & Davies, T.J. (2015) Spatial incongruence
among hotspots and complementary areas of tree diversity in southern Africa.
\emph{Diversity and Distributions} \strong{21}, 769-780.

Drummond, A.J., & Rambaut, A. (2007). BEAST: Bayesian evolutionary analysis
by sampling trees. \emph{BMC Evolutionary Biology} \strong{7}, 214.

Duff, I.S. (1977). A survey of sparse matrix research. \emph{Proceedings
of the IEEE} \strong{65}, 500–535.

Webb, C.O., & Donoghue, M.J. (2005). Phylomatic: Tree assembly for applied
phylogenetics. \emph{Molecular Ecology Notes} \strong{5}, 181–183.
}
\keyword{datasets}
