% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_detection.R
\name{optimize_resolution}
\alias{optimize_resolution}
\title{Optimize resolution parameter using silhouette score}
\usage{
optimize_resolution(
  g,
  distance_matrix,
  target_clusters = 80,
  resolution_range_low = 0.1,
  resolution_range_high = 0.5,
  max_steps = 20,
  ncores = 1
)
}
\arguments{
\item{g}{An igraph graph object with weighted edges}

\item{distance_matrix}{The distance matrix (as dist object) used for silhouette calculation}

\item{target_clusters}{Target number of clusters for initial tuning. Default is 80.}

\item{resolution_range_low}{Fractional range below tuned resolution. Default is 0.1.}

\item{resolution_range_high}{Fractional range above tuned resolution. Default is 0.5.}

\item{max_steps}{Maximum steps for initial tuning. Default is 20.}

\item{ncores}{Number of cores for parallel processing. Default is 1.}
}
\value{
A list containing:
\itemize{
\item \code{results}: data.frame with Resolution, ClusterCount, Silhouette
\item \code{partitions}: list of membership vectors for each resolution
\item \code{best_resolution}: optimal resolution parameter
\item \code{best_partition}: membership vector at optimal resolution
\item \code{best_clusters}: number of clusters at optimal resolution
}
}
\description{
Performs a grid search over resolution parameters and selects the one
that maximizes the silhouette score.
}
\seealso{
\code{\link{detect_communities_leiden}}, \code{\link{igClust}}
}
