% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotCommunityNetwork}
\alias{plotCommunityNetwork}
\title{Plot community network}
\usage{
plotCommunityNetwork(
  x,
  layout = c("fr", "kk", "circle"),
  node_color = "cluster",
  node_size = "degree",
  edge_alpha = 0.3,
  show_labels = TRUE,
  label_size = 3,
  ...
)
}
\arguments{
\item{x}{A GermlineCluster object with Leiden clustering}

\item{layout}{Network layout: "fr" (Fruchterman-Reingold, default), "kk" (Kamada-Kawai), or "circle"}

\item{node_color}{Variable for node color: "cluster" (default), "family", or a color value}

\item{node_size}{Variable for node size: "degree" (default), "fixed", or a numeric value}

\item{edge_alpha}{Alpha transparency for edges. Default is 0.3.}

\item{show_labels}{Logical. Show node labels. Default is TRUE.}

\item{label_size}{Size of node labels. Default is 3.}

\item{...}{Additional arguments}
}
\value{
A ggplot object
}
\description{
Creates a network visualization of allele clusters from community detection.
}
\details{
This function creates a network visualization showing:
\itemize{
\item Nodes representing alleles, colored by cluster
\item Edges weighted by sequence similarity
\item Layout optimized by specified algorithm
}
}
\examples{
\donttest{
data(HVGERM)
asc <- inferAlleleClusters(HVGERM[1:30],
                           clustering_method = "leiden",
                           target_clusters = 5)
plotCommunityNetwork(asc)
}

}
\seealso{
\code{\link{inferAlleleClusters}}, \code{\link{detect_communities_leiden}}
}
