% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infcrit.dof.R
\name{infcrit.dof}
\alias{infcrit.dof}
\title{Information criteria}
\usage{
infcrit.dof(modplsR, naive = FALSE)
}
\arguments{
\item{modplsR}{A plsR model i.e. an object returned by one of the functions
\code{plsR}, \code{plsRmodel.default}, \code{plsRmodel.formula},
\code{PLS_lm} or \code{PLS_lm_formula}.}

\item{naive}{A boolean.}
}
\value{
\item{matrix}{AIC, BIC and gmdl values or \code{NULL}.}
}
\description{
This function computes information criteria for existing plsR model using
Degrees of Freedom estimation.
}
\details{
If \code{naive=FALSE} returns AIC, BIC and gmdl values for estimated and
naive degrees of freedom. If \code{naive=TRUE} returns \code{NULL}.
}
\examples{

data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
modpls <- plsR(yCornell,XCornell,4)
infcrit.dof(modpls)

}
\references{
M. Hansen, B. Yu. (2001). Model Selection and Minimum Descripion
Length Principle, \emph{Journal of the American Statistical Association},
96, 746-774.\cr N. Kraemer, M. Sugiyama. (2011). The Degrees of Freedom of
Partial Least Squares Regression. \emph{Journal of the American Statistical
Association}, 106(494), 697-705.\cr N. Kraemer, M. Sugiyama, M.L. Braun.
(2009). Lanczos Approximations for the Speedup of Kernel Partial Least
Squares Regression, \emph{Proceedings of the Twelfth International
Conference on Artificial Intelligence and Statistics (AISTATS)}, 272-279.
}
\seealso{
\code{\link{plsR.dof}} for degrees of freedom computation and
\code{\link{infcrit.dof}} for computing information criteria directly from a
previously fitted plsR model.
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{models}
\keyword{regression}
\keyword{utilities}
