% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_logLik.R
\docType{methods}
\name{cond_logLik}
\alias{cond_logLik}
\alias{cond_logLik,missing-method}
\alias{cond_logLik,ANY-method}
\alias{cond_logLik,kalmand_pomp-method}
\alias{cond_logLik,pfilterd_pomp-method}
\alias{cond_logLik,wpfilterd_pomp-method}
\alias{cond_logLik,bsmcd_pomp-method}
\alias{cond_logLik,pfilterList-method}
\title{Conditional log likelihood}
\usage{
\S4method{cond_logLik}{kalmand_pomp}(object, ..., format = c("numeric", "data.frame"))

\S4method{cond_logLik}{pfilterd_pomp}(object, ..., format = c("numeric", "data.frame"))

\S4method{cond_logLik}{wpfilterd_pomp}(object, ..., format = c("numeric", "data.frame"))

\S4method{cond_logLik}{bsmcd_pomp}(object, ..., format = c("numeric", "data.frame"))

\S4method{cond_logLik}{pfilterList}(object, ..., format = c("numeric", "data.frame"))
}
\arguments{
\item{object}{result of a filtering computation}

\item{...}{ignored}

\item{format}{format of the returned object}
}
\value{
The numerical value of the conditional log likelihood.
Note that some methods compute not the log likelihood itself but instead a related quantity.
To keep the code simple, the \code{cond_logLik} function is nevertheless used to extract this quantity.

When \code{object} is of class \sQuote{bsmcd_pomp}
(i.e., the result of a \code{bsmc2} computation),
\code{cond_logLik} returns the conditional log \dQuote{evidence}
(see \code{\link{bsmc2}}).
}
\description{
The estimated conditional log likelihood from a fitted model.
}
\details{
The conditional likelihood is defined to be the value of the density
of \deqn{Y(t_k) | Y(t_1),\dots,Y(t_{k-1})}{Yk | Y1,\dots,Y(k-1)} evaluated at \eqn{Y(t_k) = y^*_k}{Yk = yk*}.
Here, \eqn{Y(t_k)}{Yk} is the observable process, and \eqn{y^*_k}{yk*} the data, at time \eqn{t_k}.

Thus the conditional log likelihood at time \eqn{t_k} is
\deqn{\ell_k(\theta) = \log f[Y(t_k)=y^*_k \vert Y(t_1)=y^*_1, \dots, Y(t_{k-1})=y^*_{k-1}],}{ell_k(theta)=log f[Yk = yk* | Y1=y1*, \dots, Y(k-1)=y(k-1)*],}
where \eqn{f} is the probability density above.
}
\seealso{
More on sequential Monte Carlo methods:
\code{\link{bsmc2}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{wpfilter}()}

Other extraction methods: 
\code{\link{coef}()},
\code{\link{covmat}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{time}()},
\code{\link{timezero}()},
\code{\link{traces}()}
}
\concept{extraction methods}
\concept{particle filter methods}
