% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powergrid.R
\name{PowerDF}
\alias{PowerDF}
\title{Transform power_array into power_df}
\usage{
PowerDF(x)
}
\arguments{
\item{x}{Object of class \code{power_array}}
}
\value{
An object of with classes c("power_df", "data.frame"), with the same
attributes as \code{x}, aside from array-native attributes (dimnames, dim),
plus the data.frame attributes \code{names} and \code{row_names}.
}
\description{
Transforms an object of class \code{power_array} to a data.frame,
where values are stored in column x, and all other dimensions are
columns. Some may find this "more tidy" to work with.

The class of the data.frame becomes `c("power_df", "data.frame"), enabling
generics for data.frame. Note that the class "power_df" has currently no
use but is included for future compatibility.
}
\examples{
## Define grid of assumptions to study:
sse_pars = list(
  n = seq(from = 10, to = 50, by = 20),         # sample size
  delta = seq(from = 0.5, to = 1.5, by = 0.5), # effect size
  sd = seq(.1, 1, .3))                        # standard deviation

## Define function that calculates power based on these assumptions:
PowFun <- function(n, delta, sd){
  ptt = power.t.test(n = n/2, delta = delta, sd = sd,
                     sig.level = 0.05)
  return(ptt$power)
}

## Evaluate at each combination of assumptions: 
powarr = PowerGrid(pars = sse_pars, fun = PowFun, n_iter = NA)
print(PowerDF(powarr))
}
\seealso{
\code{\link{PowerGrid}}
}
\author{
Gilles Dutilh
}
