% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcs_ptp.R
\name{calculate_dcs_1993_vascular_disease_index}
\alias{calculate_dcs_1993_vascular_disease_index}
\title{Calculate The Vascular Disease Index For Duke Clinical Score 1993}
\usage{
calculate_dcs_1993_vascular_disease_index(
  have_peripheral_vascular_disease,
  have_cerebrovascular_disease,
  have_carotid_bruits,
  max_na = 0,
  label_have_pvd_no = c("no"),
  label_have_pvd_yes = c("yes"),
  label_have_pvd_unknown = c(NA, NaN),
  label_have_cvd_no = c("no"),
  label_have_cvd_yes = c("yes"),
  label_have_cvd_unknown = c(NA, NaN),
  label_have_carotid_bruits_no = c("no"),
  label_have_carotid_bruits_yes = c("yes"),
  label_have_carotid_bruits_unknown = c(NA, NaN),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{have_peripheral_vascular_disease}{The value of variable in the parameters
\code{label_have_pvd_no}, \code{label_have_pvd_yes}
and \code{label_have_pvd_unknown}.}

\item{have_cerebrovascular_disease}{The value of variable in the parameters
\code{label_have_cvd_no}, \code{label_have_cvd_yes}
and \code{label_have_cvd_unknown}.}

\item{have_carotid_bruits}{The value of variable in the parameters
\code{label_have_carotid_bruits_no}, \code{label_have_carotid_bruits_yes}
and \code{label_have_carotid_bruits_unknown}.}

\item{max_na}{Input integer 0 to 3 to indicate the maximum number of
missing disease history to tolerate before outputting an \code{NA}.
Default: 0}

\item{label_have_pvd_no}{Label(s) for patient not having peripheral vascular disease.
Default: \code{c("no")}}

\item{label_have_pvd_yes}{Label(s) for patient having peripheral vascular disease.
Default: \code{c("yes")}}

\item{label_have_pvd_unknown}{Label(s) for patient
having unknown peripheral vascular disease.
Default: \code{c(NA, NaN)}}

\item{label_have_cvd_no}{Label(s) for patient not having cerebrovascular disease.
Default: \code{c("no")}}

\item{label_have_cvd_yes}{Label(s) for patient having cerebrovascular disease.
Default: \code{c("yes")}}

\item{label_have_cvd_unknown}{Label(s) for patient
having unknown cerebrovascular disease.
Default: \code{c(NA, NaN)}}

\item{label_have_carotid_bruits_no}{Label(s) for patient not having carotid bruits.
Default: \code{c("no")}}

\item{label_have_carotid_bruits_yes}{Label(s) for patient having carotid bruits.
Default: \code{c("yes")}}

\item{label_have_carotid_bruits_unknown}{Label(s) for patient
having unknown carotid bruits.
Default: \code{c(NA, NaN)}}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An integer indicating the patient's vascular disease index.
It can also be \code{NA} if the number of missing disease history exceeds the \code{max_na}
input value.
}
\description{
A function used to calculate the patient's
vascular disease index. This is used to calculate the likelihood
of severe coronary artery disease in the
Duke Clinical Score 1993 paper.
}
\examples{
calculate_dcs_1993_vascular_disease_index(
  have_peripheral_vascular_disease = "yes",
  have_cerebrovascular_disease = "yes",
  have_carotid_bruits = "no"
)

calculate_dcs_1993_vascular_disease_index(
  have_peripheral_vascular_disease = NA,
  have_cerebrovascular_disease = "yes",
  have_carotid_bruits = "no",
  max_na = 0
)

calculate_dcs_1993_vascular_disease_index(
  have_peripheral_vascular_disease = NA,
  have_cerebrovascular_disease = "yes",
  have_carotid_bruits = "no",
  max_na = 1
)
}
