% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindGlobalOpt.R
\name{find_global_optima}
\alias{find_global_optima}
\title{Global Optimization of Approximation Error}
\usage{
find_global_optima(PWL, f, tol = 1e-06)
}
\arguments{
\item{PWL}{A matrix with 4 columns: slope, intercept, lower bound, upper bound.}

\item{f}{The original function to approximate.}

\item{tol}{Tolerance for optimizer convergence.}
}
\value{
A matrix with 4 columns:
x_min (location of min error), min_error,
x_max (location of max error), max_error.
}
\description{
This function computes the global minimum and maximum of the absolute error
between the target function \code{f} and its piecewise linear (PWL) approximation
across each linear segment.
}
\keyword{internal}
