% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetHinfo.R
\name{GetH1Equal}
\alias{GetH1Equal}
\title{Specify the configurations corresponding to the composite \eqn{H_1} test "Equal".}
\usage{
GetH1Equal(Hconfig, Equal, Consecutive = FALSE, SameSign = FALSE)
}
\arguments{
\item{Hconfig}{A list of all possible combination of H0 and H1 hypotheses generated by the \code{\link[=GetHconfig]{GetHconfig()}} function.}

\item{Equal}{What is the exact number of \eqn{H_1} hypotheses for the item to be of interest? (an integer or a vector).}

\item{Consecutive}{Should the significant test series be consecutive ? (optional, default is FALSE).}

\item{SameSign}{Should the significant test series have the same sign ? (optional, default is FALSE).}
}
\value{
A vector '\code{Hconfig.H1}' of components of \code{Hconfig} that correspond to the '\code{Equal}' specification.
}
\description{
Specify which configurations among \code{Hconfig} correspond
to the composite alternative hypothesis :\{Exactly "\code{Equal}" \eqn{H_1} hypotheses are of interest \}
}
\examples{
GetH1Equal(GetHconfig(4), 2)

}
\seealso{
\code{\link[=GetH1AtLeast]{GetH1AtLeast()}}
}
