% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcrlscR.R
\name{outl.det.u}
\alias{outl.det.u}
\title{Univariate outlier detection}
\usage{
outl.det.u(x, method = c("percentile", "median"))
}
\arguments{
\item{x}{a numeric vector.}

\item{method}{method for univariate outlier detection. Only \code{percentile}
and \code{median} are supported.}
}
\value{
a logical vector.
}
\description{
Perform outlier detection using univariate method.
}
\details{
\itemize{
\item \code{median}: the absolute difference between the observation and the sample
median is larger than 2 times of the Median Absolute Deviation divided
by 0.6745.
\item \code{percentile}: either smaller than the 1st quartile minus 1.5 times of
IQR, or larger than the 3rd quartile plus 1.5 times of IQR.
}
}
\examples{
x <- c(2, 3, 4, 5, 6, 7, NA, 9, 50, 50)
outl.det.u(x, "percentile")
}
\references{
Wilcox R R, Fundamentals of Modern Statistical Methods: Substantially
Improving Power and Accuracy, Springer 2010 (2nd edition), pages 31-35.
}
