% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sql_lines.R
\name{read_sql_lines}
\alias{read_sql_lines}
\title{Standardizes lines read from string, character vector, or file}
\usage{
read_sql_lines(x)
}
\arguments{
\item{x}{a filepath or character vector containing SQL}
}
\value{
A \code{qryflow_sql} object (inherits from character) with a length equal to the number of lines read
}
\description{
This is a generic function to ensure lines read from a file, a single
character vector, or already parsed lines return the same format. This helps
avoid re-reading entire texts by enabling already read lines to pass easily.

This is useful for folks who may want to extend qryflow.
}
\examples{
# From a file #####
path <- example_sql_path()
read_sql_lines(path)

# From a single string #####
sql <- "SELECT *
FROM mtcars;"
read_sql_lines(sql)

# From a character #####
lines <- c("SELECT *", "FROM mtcars;")
read_sql_lines(lines)
}
